/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.shipment.basic;

import com.sleepycat.bdb.TransactionRunner;
import com.sleepycat.bdb.TransactionWorker;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredMap;
import com.sleepycat.db.DbException;
import com.sleepycat.examples.bdb.shipment.basic.PartKey;
import com.sleepycat.examples.bdb.shipment.basic.PartValue;
import com.sleepycat.examples.bdb.shipment.basic.SampleDatabase;
import com.sleepycat.examples.bdb.shipment.basic.SampleViews;
import com.sleepycat.examples.bdb.shipment.basic.ShipmentKey;
import com.sleepycat.examples.bdb.shipment.basic.ShipmentValue;
import com.sleepycat.examples.bdb.shipment.basic.SupplierKey;
import com.sleepycat.examples.bdb.shipment.basic.SupplierValue;
import com.sleepycat.examples.bdb.shipment.basic.Weight;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class Sample {
    private SampleDatabase db;
    private SampleViews views;
    static /* synthetic */ Class class$com$sleepycat$examples$bdb$shipment$basic$Sample;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("\nRunning sample: " + (class$com$sleepycat$examples$bdb$shipment$basic$Sample == null ? (class$com$sleepycat$examples$bdb$shipment$basic$Sample = Sample.class$("com.sleepycat.examples.bdb.shipment.basic.Sample")) : class$com$sleepycat$examples$bdb$shipment$basic$Sample));
        boolean runRecovery = true;
        String homeDir = "./tmp";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (args[i].equals("-h") && i < args.length - 1) {
                homeDir = args[++i];
            } else if (args[i].equals("-multiprocess")) {
                runRecovery = false;
            } else {
                System.err.println("Usage:\n java " + (class$com$sleepycat$examples$bdb$shipment$basic$Sample == null ? Sample.class$("com.sleepycat.examples.bdb.shipment.basic.Sample") : class$com$sleepycat$examples$bdb$shipment$basic$Sample).getName() + "\n  [-h <home-directory>] [-multiprocess]");
                System.exit(2);
            }
            ++i;
        }
        Sample sample = null;
        try {
            sample = new Sample(homeDir, runRecovery);
            sample.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (sample != null) {
                try {
                    sample.close();
                }
                catch (Exception e) {
                    System.err.println("Exception during database close:");
                    e.printStackTrace();
                }
            }
        }
    }

    private Sample(String homeDir, boolean runRecovery) throws DbException, FileNotFoundException {
        this.db = new SampleDatabase(homeDir, runRecovery);
        this.views = new SampleViews(this.db);
    }

    private void close() throws DbException, IOException {
        this.db.close();
    }

    private void run() throws Exception {
        TransactionRunner runner = new TransactionRunner(this.db.getEnvironment());
        runner.run((TransactionWorker)new PopulateDatabase());
        runner.run((TransactionWorker)new PrintDatabase());
    }

    private void addParts() {
        StoredMap parts = this.views.getPartMap();
        if (parts.isEmpty()) {
            System.out.println("Adding Parts");
            parts.put(new PartKey("P1"), new PartValue("Nut", "Red", new Weight(12.0, "grams"), "London"));
            parts.put(new PartKey("P2"), new PartValue("Bolt", "Green", new Weight(17.0, "grams"), "Paris"));
            parts.put(new PartKey("P3"), new PartValue("Screw", "Blue", new Weight(17.0, "grams"), "Rome"));
            parts.put(new PartKey("P4"), new PartValue("Screw", "Red", new Weight(14.0, "grams"), "London"));
            parts.put(new PartKey("P5"), new PartValue("Cam", "Blue", new Weight(12.0, "grams"), "Paris"));
            parts.put(new PartKey("P6"), new PartValue("Cog", "Red", new Weight(19.0, "grams"), "London"));
        }
    }

    private void addSuppliers() {
        StoredMap suppliers = this.views.getSupplierMap();
        if (suppliers.isEmpty()) {
            System.out.println("Adding Suppliers");
            suppliers.put(new SupplierKey("S1"), new SupplierValue("Smith", 20, "London"));
            suppliers.put(new SupplierKey("S2"), new SupplierValue("Jones", 10, "Paris"));
            suppliers.put(new SupplierKey("S3"), new SupplierValue("Blake", 30, "Paris"));
            suppliers.put(new SupplierKey("S4"), new SupplierValue("Clark", 20, "London"));
            suppliers.put(new SupplierKey("S5"), new SupplierValue("Adams", 30, "Athens"));
        }
    }

    private void addShipments() {
        StoredMap shipments = this.views.getShipmentMap();
        if (shipments.isEmpty()) {
            System.out.println("Adding Shipments");
            shipments.put(new ShipmentKey("P1", "S1"), new ShipmentValue(300));
            shipments.put(new ShipmentKey("P2", "S1"), new ShipmentValue(200));
            shipments.put(new ShipmentKey("P3", "S1"), new ShipmentValue(400));
            shipments.put(new ShipmentKey("P4", "S1"), new ShipmentValue(200));
            shipments.put(new ShipmentKey("P5", "S1"), new ShipmentValue(100));
            shipments.put(new ShipmentKey("P6", "S1"), new ShipmentValue(100));
            shipments.put(new ShipmentKey("P1", "S2"), new ShipmentValue(300));
            shipments.put(new ShipmentKey("P2", "S2"), new ShipmentValue(400));
            shipments.put(new ShipmentKey("P2", "S3"), new ShipmentValue(200));
            shipments.put(new ShipmentKey("P2", "S4"), new ShipmentValue(200));
            shipments.put(new ShipmentKey("P4", "S4"), new ShipmentValue(300));
            shipments.put(new ShipmentKey("P5", "S4"), new ShipmentValue(400));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printEntries(String label, Iterator iterator) {
        System.out.println("\n--- " + label + " ---");
        try {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                System.out.println(entry.getKey().toString());
                System.out.println(entry.getValue().toString());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StoredIterator.close((Iterator)iterator);
            throw throwable;
        }
        StoredIterator.close((Iterator)iterator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PrintDatabase
    implements TransactionWorker {
        private PrintDatabase() {
        }

        public void doWork() throws Exception {
            Sample.this.printEntries("Parts", Sample.this.views.getPartEntrySet().iterator());
            Sample.this.printEntries("Suppliers", Sample.this.views.getSupplierEntrySet().iterator());
            Sample.this.printEntries("Shipments", Sample.this.views.getShipmentEntrySet().iterator());
        }
    }

    private class PopulateDatabase
    implements TransactionWorker {
        private PopulateDatabase() {
        }

        public void doWork() throws Exception {
            Sample.this.addSuppliers();
            Sample.this.addParts();
            Sample.this.addShipments();
        }
    }
}

