/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.examples.bdb.access;

import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.TransactionRunner;
import com.sleepycat.bdb.TransactionWorker;
import com.sleepycat.bdb.bind.ByteArrayBinding;
import com.sleepycat.bdb.bind.ByteArrayFormat;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredSortedMap;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

public class AccessExample
implements Runnable {
    private static boolean create = true;
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;
    private DataStore store;
    private SortedMap map;
    private DbEnv env;

    public static void usage() {
        System.out.println("usage: java com.sleepycat.examples.bdb.access.AccessExample [-r] [database]\n");
        System.exit(1);
    }

    public static void main(String[] argv) {
        boolean removeExistingDatabase = false;
        String databaseName = "access.db";
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-r")) {
                removeExistingDatabase = true;
            } else if (argv[i].equals("-?")) {
                AccessExample.usage();
            } else if (argv[i].startsWith("-")) {
                AccessExample.usage();
            } else {
                if (argv.length - i != 1) {
                    AccessExample.usage();
                }
                databaseName = argv[i];
                break;
            }
            ++i;
        }
        try {
            if (removeExistingDatabase) {
                new File(databaseName).delete();
            }
            int envFlags = Db.DB_INIT_TXN | Db.DB_INIT_LOCK | Db.DB_INIT_MPOOL;
            if (create) {
                envFlags |= Db.DB_CREATE;
            }
            if (!removeExistingDatabase) {
                envFlags |= Db.DB_RECOVER;
            }
            DbEnv env = new DbEnv(0);
            env.open(".", envFlags, 0);
            AccessExample app = new AccessExample(env, databaseName);
            app.run();
        }
        catch (DbException e) {
            System.err.println("AccessExample: " + e.toString());
            System.exit(1);
        }
        catch (FileNotFoundException e) {
            System.err.println("AccessExample: " + e.toString());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("AccessExample: " + e.toString());
            System.exit(1);
        }
        System.exit(0);
    }

    public AccessExample(DbEnv env, String databaseName) throws Exception {
        this.env = env;
        ByteArrayFormat keyFormat = new ByteArrayFormat();
        ByteArrayBinding keyBinding = new ByteArrayBinding(keyFormat);
        ByteArrayFormat valueFormat = new ByteArrayFormat();
        ByteArrayBinding valueBinding = new ByteArrayBinding(valueFormat);
        int dbFlags = Db.DB_AUTO_COMMIT;
        if (create) {
            dbFlags |= Db.DB_CREATE;
        }
        Db db = new Db(env, 0);
        db.open(null, databaseName, null, 1, dbFlags, 0);
        this.store = new DataStore(db, (DataFormat)keyFormat, (DataFormat)valueFormat, null);
        this.map = new StoredSortedMap(this.store, (DataBinding)keyBinding, (DataBinding)valueBinding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String line;
        InputStreamReader reader = new InputStreamReader(System.in);
        while ((line = this.askForLine(reader, System.out, "input> ")) != null) {
            final String reversed = new StringBuffer(line).reverse().toString();
            this.log("adding: \"" + line + "\" : \"" + reversed + "\"");
            TransactionRunner tr = new TransactionRunner(this.env);
            try {
                tr.run(new TransactionWorker(){

                    public void doWork() {
                        if (!AccessExample.this.map.containsKey(line.getBytes())) {
                            AccessExample.this.map.put(line.getBytes(), reversed.getBytes());
                        } else {
                            System.out.println("Key " + line + " already exists.");
                        }
                    }
                });
            }
            catch (DbException e) {
                System.err.println("AccessExample: " + e.toString());
                System.exit(1);
            }
            catch (Exception e) {
                System.err.println("AccessExample: " + e.toString());
                System.exit(1);
            }
        }
        System.out.println("");
        Iterator iter = this.map.entrySet().iterator();
        try {
            System.out.println("Reading data");
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.log("found \"" + new String((byte[])entry.getKey()) + "\" key with value \"" + new String((byte[])entry.getValue()) + "\"");
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            StoredIterator.close(iter);
            throw throwable;
        }
        StoredIterator.close(iter);
    }

    String askForLine(InputStreamReader reader, PrintStream out, String prompt) {
        String result = "";
        while (result != null && result.length() == 0) {
            out.print(prompt);
            out.flush();
            result = this.getLine(reader);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    String getLine(InputStreamReader reader) {
        int c;
        StringBuffer b = new StringBuffer();
        try {
            while ((c = reader.read()) != -1 && c != 10) {
                void var3_3;
                if (var3_3 == 13) continue;
                b.append((char)var3_3);
            }
        }
        catch (IOException ioe) {
            c = -1;
        }
        if (c == -1 && b.length() == 0) {
            return null;
        }
        return b.toString();
    }

    private void log(String s) {
        System.out.println(s);
        System.out.flush();
    }
}

