/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

class DbUtil {
    private static final boolean big_endian = DbUtil.is_big_endian();

    DbUtil() {
    }

    static int array2int(byte[] arr, int offset) {
        int b1;
        int b2;
        int b3;
        int b4;
        int pos = offset;
        if (big_endian) {
            b4 = arr[pos++];
            b3 = arr[pos++];
            b2 = arr[pos++];
            b1 = arr[pos];
        } else {
            b1 = arr[pos++];
            b2 = arr[pos++];
            b3 = arr[pos++];
            b4 = arr[pos];
        }
        if (b1 < 0) {
            b1 += 256;
        }
        if (b2 < 0) {
            b2 += 256;
        }
        if (b3 < 0) {
            b3 += 256;
        }
        if (b4 < 0) {
            b4 += 256;
        }
        return b1 + (b2 <<= 8) + (b3 <<= 16) + (b4 <<= 24);
    }

    static void int2array(int n, byte[] arr, int offset) {
        int pos = offset;
        int b1 = n & 0xFF;
        int b2 = n >> 8 & 0xFF;
        int b3 = n >> 16 & 0xFF;
        int b4 = n >> 24 & 0xFF;
        if (b1 >= 128) {
            b1 -= 256;
        }
        if (b2 >= 128) {
            b2 -= 256;
        }
        if (b3 >= 128) {
            b3 -= 256;
        }
        if (b4 >= 128) {
            b4 -= 256;
        }
        if (big_endian) {
            arr[pos++] = (byte)b4;
            arr[pos++] = (byte)b3;
            arr[pos++] = (byte)b2;
            arr[pos] = (byte)b1;
        } else {
            arr[pos++] = (byte)b1;
            arr[pos++] = (byte)b2;
            arr[pos++] = (byte)b3;
            arr[pos] = (byte)b4;
        }
    }

    public static String byteArrayToString(byte[] barr) {
        if (barr == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int len = barr.length;
        int i = 0;
        while (i < len) {
            sb.append('x');
            int val = barr[i] >> 4 & 0xF;
            if (val < 10) {
                sb.append((char)(48 + val));
            } else {
                sb.append((char)(97 + val - 10));
            }
            val = barr[i] & 0xF;
            if (val < 10) {
                sb.append((char)(48 + val));
            } else {
                sb.append((char)(97 + val - 10));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String objectArrayToString(Object[] arr, String name) {
        if (arr == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int len = arr.length;
        int i = 0;
        while (i < len) {
            sb.append("\n    " + name + "[" + i + "]:\n");
            sb.append("    " + arr[i].toString());
            ++i;
        }
        return sb.toString();
    }

    private static native boolean is_big_endian();
}

