/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbAppDispatch;
import com.sleepycat.db.DbClient;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnvFeedback;
import com.sleepycat.db.DbEnvFeedbackHandler;
import com.sleepycat.db.DbErrcall;
import com.sleepycat.db.DbErrorHandler;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbLock;
import com.sleepycat.db.DbLockNotGrantedException;
import com.sleepycat.db.DbLockRequest;
import com.sleepycat.db.DbLockStat;
import com.sleepycat.db.DbLogStat;
import com.sleepycat.db.DbLogc;
import com.sleepycat.db.DbLsn;
import com.sleepycat.db.DbMpoolFStat;
import com.sleepycat.db.DbMpoolStat;
import com.sleepycat.db.DbPanicHandler;
import com.sleepycat.db.DbPreplist;
import com.sleepycat.db.DbRepStat;
import com.sleepycat.db.DbRepTransport;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.DbTxnStat;
import com.sleepycat.db.Dbt;
import com.sleepycat.db.db_java;
import com.sleepycat.db.db_javaJNI;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class DbEnv {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Object dbenv_ref;
    private DbAppDispatch app_dispatch_handler;
    private DbEnvFeedbackHandler env_feedback_handler;
    private DbErrorHandler error_handler;
    private DbPanicHandler panic_handler;
    private DbRepTransport rep_transport_handler;
    private String errpfx;

    protected DbEnv(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected DbEnv() {
        this(0L, false);
    }

    protected void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(DbEnv obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    void initialize() {
        this.dbenv_ref = db_java.initDbEnvRef0(this, this);
        this.set_error_stream(System.err);
    }

    void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.dbenv_ref);
        this.dbenv_ref = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int flags) throws DbException {
        try {
            this.close0(flags);
            Object var3_2 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    private final int handle_app_dispatch(Dbt dbt, DbLsn lsn, int recops) {
        return this.app_dispatch_handler.appDispatch(this, dbt, lsn, recops);
    }

    private final void handle_env_feedback(int opcode, int percent) {
        this.env_feedback_handler.feedback(this, opcode, percent);
    }

    private final void handle_error(String msg) {
        this.error_handler.error(this.errpfx, msg);
    }

    private final void handle_panic(DbException e) {
        this.panic_handler.panic(this, e);
    }

    private final int handle_rep_transport(Dbt control, Dbt rec, DbLsn lsn, int flags, int envid) throws DbException {
        return this.rep_transport_handler.send(this, control, rec, lsn, flags, envid);
    }

    public void lock_vec(int locker, int flags, DbLockRequest[] list, int offset, int count) throws DbException {
        this.lockVector(locker, flags, list, offset, count);
    }

    public void lockVector(int locker, int flags, DbLockRequest[] list, int offset, int count) throws DbException {
        db_javaJNI.DbEnv_lock_vec(this.swigCPtr, locker, flags, list, offset, count);
    }

    public void open(String db_home, int flags, int mode) throws DbException, FileNotFoundException {
        this.open0(db_home, flags |= Db.DB_THREAD, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String db_home, int flags) throws DbException, FileNotFoundException {
        try {
            this.remove0(db_home, flags);
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void set_cachesize(int gbytes, int bytes, int ncache) throws DbException {
        this.set_cachesize((long)gbytes * 0x40000000L + (long)bytes, ncache);
    }

    public String get_errpfx() {
        return this.getErrorPrefix();
    }

    public String getErrorPrefix() {
        return this.errpfx;
    }

    public void set_errcall(DbErrcall db_errcall_fcn) throws DbException {
        final DbErrcall ferrcall = db_errcall_fcn;
        try {
            this.setErrorHandler(new DbErrorHandler(){

                public void error(String prefix, String buffer) {
                    ferrcall.errcall(prefix, buffer);
                }
            });
        }
        catch (DbException dbe) {
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbe);
            dbe.printStackTrace(System.err);
        }
    }

    public void set_error_stream(OutputStream stream) {
        this.setErrorStream(stream);
    }

    public void setErrorStream(OutputStream stream) {
        final PrintWriter pw = new PrintWriter(stream);
        try {
            this.setErrorHandler(new DbErrorHandler(){

                public void error(String prefix, String buf) {
                    if (prefix != null) {
                        pw.print(prefix + ": ");
                    }
                    pw.println(buf);
                    pw.flush();
                }
            });
        }
        catch (DbException dbe) {
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbe);
            dbe.printStackTrace(System.err);
        }
    }

    public void set_errpfx(String errpfx) {
        this.setErrorPrefix(errpfx);
    }

    public void setErrorPrefix(String errpfx) {
        this.errpfx = errpfx;
    }

    public void set_feedback(DbEnvFeedback feedback) throws DbException {
        final DbEnvFeedback ffeedback = feedback;
        this.setFeedbackHandler(new DbEnvFeedbackHandler(){

            public void feedback(DbEnv env, int opcode, int percent) {
                ffeedback.feedback(env, opcode, percent);
            }
        });
    }

    public void set_rep_limit(int gbytes, int bytes) throws DbException {
        this.set_rep_limit((long)gbytes * 0x40000000L + (long)bytes);
    }

    public void set_tx_timestamp(Date timestamp) throws DbException {
        this.setTxnTimestamp(timestamp);
    }

    public void setTxnTimestamp(Date timestamp) throws DbException {
        this.set_tx_timestamp0(timestamp.getTime() / 1000L);
    }

    public DbEnv(int flags) throws DbException {
        this(db_javaJNI.new_DbEnv(flags), true);
        this.initialize();
    }

    void close0(int flags) {
        db_javaJNI.DbEnv_close0(this.swigCPtr, flags);
    }

    public void dbremove(DbTxn txnid, String file, String database, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        this.dbRemove(txnid, file, database, flags);
    }

    public void dbRemove(DbTxn txnid, String file, String database, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        db_javaJNI.DbEnv_dbremove(this.swigCPtr, DbTxn.getCPtr(txnid), file, database, flags);
    }

    public void dbrename(DbTxn txnid, String file, String database, String newname, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        this.dbRename(txnid, file, database, newname, flags);
    }

    public void dbRename(DbTxn txnid, String file, String database, String newname, int flags) throws DbException, DbDeadlockException, DbLockNotGrantedException, FileNotFoundException {
        db_javaJNI.DbEnv_dbrename(this.swigCPtr, DbTxn.getCPtr(txnid), file, database, newname, flags);
    }

    public void err(int error, String message) {
        db_javaJNI.DbEnv_err(this.swigCPtr, error, message);
    }

    public void errx(String message) {
        db_javaJNI.DbEnv_errx(this.swigCPtr, message);
    }

    public String[] get_data_dirs() throws DbException {
        return this.getDataDirs();
    }

    public String[] getDataDirs() throws DbException {
        return db_javaJNI.DbEnv_get_data_dirs(this.swigCPtr);
    }

    public int get_encrypt_flags() throws DbException {
        return this.getEncryptFlags();
    }

    public int getEncryptFlags() throws DbException {
        return db_javaJNI.DbEnv_get_encrypt_flags(this.swigCPtr);
    }

    public int get_flags() throws DbException {
        return this.getFlags();
    }

    public int getFlags() throws DbException {
        return db_javaJNI.DbEnv_get_flags(this.swigCPtr);
    }

    public String get_home() throws DbException {
        return this.getDbEnvHome();
    }

    public String getDbEnvHome() throws DbException {
        return db_javaJNI.DbEnv_get_home(this.swigCPtr);
    }

    public int get_open_flags() throws DbException {
        return this.getOpenFlags();
    }

    public int getOpenFlags() throws DbException {
        return db_javaJNI.DbEnv_get_open_flags(this.swigCPtr);
    }

    public long get_shm_key() throws DbException {
        return this.getSegmentId();
    }

    public long getSegmentId() throws DbException {
        return db_javaJNI.DbEnv_get_shm_key(this.swigCPtr);
    }

    public int get_tas_spins() throws DbException {
        return this.getTestAndSetSpins();
    }

    public int getTestAndSetSpins() throws DbException {
        return db_javaJNI.DbEnv_get_tas_spins(this.swigCPtr);
    }

    public String get_tmp_dir() throws DbException {
        return this.getTmpDir();
    }

    public String getTmpDir() throws DbException {
        return db_javaJNI.DbEnv_get_tmp_dir(this.swigCPtr);
    }

    public boolean get_verbose(int which) throws DbException {
        return this.getVerbose(which);
    }

    public boolean getVerbose(int which) throws DbException {
        return db_javaJNI.DbEnv_get_verbose(this.swigCPtr, which);
    }

    void open0(String db_home, int flags, int mode) {
        db_javaJNI.DbEnv_open0(this.swigCPtr, db_home, flags, mode);
    }

    void remove0(String db_home, int flags) {
        db_javaJNI.DbEnv_remove0(this.swigCPtr, db_home, flags);
    }

    public void set_cachesize(long bytes, int ncache) throws DbException {
        this.setCacheSize(bytes, ncache);
    }

    public void setCacheSize(long bytes, int ncache) throws DbException {
        db_javaJNI.DbEnv_set_cachesize(this.swigCPtr, bytes, ncache);
    }

    public void set_data_dir(String dir) throws DbException {
        this.setDataDir(dir);
    }

    public void setDataDir(String dir) throws DbException {
        db_javaJNI.DbEnv_set_data_dir(this.swigCPtr, dir);
    }

    public void set_encrypt(String passwd, int flags) throws DbException {
        this.setEncrypted(passwd, flags);
    }

    public void setEncrypted(String passwd, int flags) throws DbException {
        db_javaJNI.DbEnv_set_encrypt(this.swigCPtr, passwd, flags);
    }

    public void setErrorHandler(DbErrorHandler db_errcall_fcn) throws DbException {
        this.error_handler = db_errcall_fcn;
        db_javaJNI.DbEnv_setErrorHandler(this.swigCPtr, this.error_handler);
    }

    public void set_flags(int flags, boolean onoff) throws DbException {
        this.setFlags(flags, onoff);
    }

    public void setFlags(int flags, boolean onoff) throws DbException {
        db_javaJNI.DbEnv_set_flags(this.swigCPtr, flags, onoff);
    }

    public void setFeedbackHandler(DbEnvFeedbackHandler db_feedback_fcn) throws DbException {
        this.env_feedback_handler = db_feedback_fcn;
        db_javaJNI.DbEnv_setFeedbackHandler(this.swigCPtr, this.env_feedback_handler);
    }

    public void set_mp_mmapsize(long mp_mmapsize) throws DbException {
        this.setMemoryPoolMapSize(mp_mmapsize);
    }

    public void setMemoryPoolMapSize(long mp_mmapsize) throws DbException {
        db_javaJNI.DbEnv_set_mp_mmapsize(this.swigCPtr, mp_mmapsize);
    }

    public void setPanicHandler(DbPanicHandler db_panic_fcn) throws DbException {
        this.panic_handler = db_panic_fcn;
        db_javaJNI.DbEnv_setPanicHandler(this.swigCPtr, this.panic_handler);
    }

    public void set_rpc_server(DbClient client, String host, long cl_timeout, long sv_timeout, int flags) throws DbException {
        this.setRpcServer(client, host, cl_timeout, sv_timeout, flags);
    }

    public void setRpcServer(DbClient client, String host, long cl_timeout, long sv_timeout, int flags) throws DbException {
        db_javaJNI.DbEnv_set_rpc_server(this.swigCPtr, client, host, cl_timeout, sv_timeout, flags);
    }

    public void set_shm_key(long shm_key) throws DbException {
        this.setSegmentId(shm_key);
    }

    public void setSegmentId(long shm_key) throws DbException {
        db_javaJNI.DbEnv_set_shm_key(this.swigCPtr, shm_key);
    }

    public void set_tas_spins(int tas_spins) throws DbException {
        this.setTestAndSetSpins(tas_spins);
    }

    public void setTestAndSetSpins(int tas_spins) throws DbException {
        db_javaJNI.DbEnv_set_tas_spins(this.swigCPtr, tas_spins);
    }

    public void set_timeout(long timeout, int flags) throws DbException {
        this.setTimeout(timeout, flags);
    }

    public void setTimeout(long timeout, int flags) throws DbException {
        db_javaJNI.DbEnv_set_timeout(this.swigCPtr, timeout, flags);
    }

    public void set_tmp_dir(String dir) throws DbException {
        this.setTmpDir(dir);
    }

    public void setTmpDir(String dir) throws DbException {
        db_javaJNI.DbEnv_set_tmp_dir(this.swigCPtr, dir);
    }

    public void set_tx_max(int max) throws DbException {
        this.setTxnMax(max);
    }

    public void setTxnMax(int max) throws DbException {
        db_javaJNI.DbEnv_set_tx_max(this.swigCPtr, max);
    }

    public void set_app_dispatch(DbAppDispatch tx_recover) throws DbException {
        this.setAppDispatch(tx_recover);
    }

    public void setAppDispatch(DbAppDispatch tx_recover) throws DbException {
        this.app_dispatch_handler = tx_recover;
        db_javaJNI.DbEnv_set_app_dispatch(this.swigCPtr, this.app_dispatch_handler);
    }

    void set_tx_timestamp0(long timestamp) {
        db_javaJNI.DbEnv_set_tx_timestamp0(this.swigCPtr, timestamp);
    }

    public void set_verbose(int which, boolean onoff) throws DbException {
        this.setVerbose(which, onoff);
    }

    public void setVerbose(int which, boolean onoff) throws DbException {
        db_javaJNI.DbEnv_set_verbose(this.swigCPtr, which, onoff);
    }

    public byte[][] get_lk_conflicts() throws DbException {
        return this.getLockConflicts();
    }

    public byte[][] getLockConflicts() throws DbException {
        return db_javaJNI.DbEnv_get_lk_conflicts(this.swigCPtr);
    }

    public int get_lk_detect() throws DbException {
        return this.getLockDetect();
    }

    public int getLockDetect() throws DbException {
        return db_javaJNI.DbEnv_get_lk_detect(this.swigCPtr);
    }

    public int get_lk_max_locks() throws DbException {
        return this.getLockMaxLocks();
    }

    public int getLockMaxLocks() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_locks(this.swigCPtr);
    }

    public int get_lk_max_lockers() throws DbException {
        return this.getLockMaxLockers();
    }

    public int getLockMaxLockers() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_lockers(this.swigCPtr);
    }

    public int get_lk_max_objects() throws DbException {
        return this.getLockMaxObjects();
    }

    public int getLockMaxObjects() throws DbException {
        return db_javaJNI.DbEnv_get_lk_max_objects(this.swigCPtr);
    }

    public int lock_detect(int flags, int atype) throws DbException {
        return this.lockDetect(flags, atype);
    }

    public int lockDetect(int flags, int atype) throws DbException {
        return db_javaJNI.DbEnv_lock_detect(this.swigCPtr, flags, atype);
    }

    public DbLock lock_get(int locker, int flags, Dbt object, int lock_mode) throws DbException {
        return this.lockGet(locker, flags, object, lock_mode);
    }

    public DbLock lockGet(int locker, int flags, Dbt object, int lock_mode) throws DbException {
        long cPtr = db_javaJNI.DbEnv_lock_get(this.swigCPtr, locker, flags, object, lock_mode);
        return cPtr == 0L ? null : new DbLock(cPtr, true);
    }

    public int lock_id() throws DbException {
        return this.lockId();
    }

    public int lockId() throws DbException {
        return db_javaJNI.DbEnv_lock_id(this.swigCPtr);
    }

    public void lock_id_free(int id) throws DbException {
        this.lockIdFree(id);
    }

    public void lockIdFree(int id) throws DbException {
        db_javaJNI.DbEnv_lock_id_free(this.swigCPtr, id);
    }

    public void lock_put(DbLock lock) throws DbException {
        this.lockPut(lock);
    }

    public void lockPut(DbLock lock) throws DbException {
        db_javaJNI.DbEnv_lock_put(this.swigCPtr, DbLock.getCPtr(lock));
    }

    public DbLockStat lock_stat(int flags) throws DbException {
        return this.lockStat(flags);
    }

    public DbLockStat lockStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_lock_stat(this.swigCPtr, flags);
    }

    public void set_lk_conflicts(byte[][] conflicts) throws DbException {
        this.setLockConflicts(conflicts);
    }

    public void setLockConflicts(byte[][] conflicts) throws DbException {
        db_javaJNI.DbEnv_set_lk_conflicts(this.swigCPtr, conflicts);
    }

    public void set_lk_detect(int detect) throws DbException {
        this.setLockDetect(detect);
    }

    public void setLockDetect(int detect) throws DbException {
        db_javaJNI.DbEnv_set_lk_detect(this.swigCPtr, detect);
    }

    public void set_lk_max_lockers(int max) throws DbException {
        this.setLockMaxLockers(max);
    }

    public void setLockMaxLockers(int max) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_lockers(this.swigCPtr, max);
    }

    public void set_lk_max_locks(int max) throws DbException {
        this.setLockMaxLocks(max);
    }

    public void setLockMaxLocks(int max) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_locks(this.swigCPtr, max);
    }

    public void set_lk_max_objects(int max) throws DbException {
        this.setLockMaxObjects(max);
    }

    public void setLockMaxObjects(int max) throws DbException {
        db_javaJNI.DbEnv_set_lk_max_objects(this.swigCPtr, max);
    }

    public int get_lg_bsize() throws DbException {
        return this.getLogBufferSize();
    }

    public int getLogBufferSize() throws DbException {
        return db_javaJNI.DbEnv_get_lg_bsize(this.swigCPtr);
    }

    public String get_lg_dir() throws DbException {
        return this.getLogDir();
    }

    public String getLogDir() throws DbException {
        return db_javaJNI.DbEnv_get_lg_dir(this.swigCPtr);
    }

    public int get_lg_max() throws DbException {
        return this.getLogMax();
    }

    public int getLogMax() throws DbException {
        return db_javaJNI.DbEnv_get_lg_max(this.swigCPtr);
    }

    public int get_lg_regionmax() throws DbException {
        return this.getLogRegionMax();
    }

    public int getLogRegionMax() throws DbException {
        return db_javaJNI.DbEnv_get_lg_regionmax(this.swigCPtr);
    }

    public String[] log_archive(int flags) throws DbException {
        return this.logArchive(flags);
    }

    public String[] logArchive(int flags) throws DbException {
        return db_javaJNI.DbEnv_log_archive(this.swigCPtr, flags);
    }

    public static int log_compare(DbLsn lsn0, DbLsn lsn1) {
        return DbEnv.logCompare(lsn0, lsn1);
    }

    public static int logCompare(DbLsn lsn0, DbLsn lsn1) {
        return db_javaJNI.DbEnv_log_compare(DbLsn.getCPtr(lsn0), DbLsn.getCPtr(lsn1));
    }

    public DbLogc log_cursor(int flags) throws DbException {
        return this.logCursor(flags);
    }

    public DbLogc logCursor(int flags) throws DbException {
        long cPtr = db_javaJNI.DbEnv_log_cursor(this.swigCPtr, flags);
        return cPtr == 0L ? null : new DbLogc(cPtr, true);
    }

    public String log_file(DbLsn lsn) throws DbException {
        return this.logFile(lsn);
    }

    public String logFile(DbLsn lsn) throws DbException {
        return db_javaJNI.DbEnv_log_file(this.swigCPtr, DbLsn.getCPtr(lsn));
    }

    public void log_flush(DbLsn lsn) throws DbException {
        this.logFlush(lsn);
    }

    public void logFlush(DbLsn lsn) throws DbException {
        db_javaJNI.DbEnv_log_flush(this.swigCPtr, DbLsn.getCPtr(lsn));
    }

    public void log_put(DbLsn lsn, Dbt data, int flags) throws DbException {
        this.logPut(lsn, data, flags);
    }

    public void logPut(DbLsn lsn, Dbt data, int flags) throws DbException {
        db_javaJNI.DbEnv_log_put(this.swigCPtr, DbLsn.getCPtr(lsn), data, flags);
    }

    public DbLogStat log_stat(int flags) throws DbException {
        return this.logStat(flags);
    }

    public DbLogStat logStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_log_stat(this.swigCPtr, flags);
    }

    public void set_lg_bsize(int lg_bsize) throws DbException {
        this.setLogBufferSize(lg_bsize);
    }

    public void setLogBufferSize(int lg_bsize) throws DbException {
        db_javaJNI.DbEnv_set_lg_bsize(this.swigCPtr, lg_bsize);
    }

    public void set_lg_dir(String dir) throws DbException {
        this.setLogDir(dir);
    }

    public void setLogDir(String dir) throws DbException {
        db_javaJNI.DbEnv_set_lg_dir(this.swigCPtr, dir);
    }

    public void set_lg_max(int lg_max) throws DbException {
        this.setLogMax(lg_max);
    }

    public void setLogMax(int lg_max) throws DbException {
        db_javaJNI.DbEnv_set_lg_max(this.swigCPtr, lg_max);
    }

    public void set_lg_regionmax(int lg_regionmax) throws DbException {
        this.setLogRegionMax(lg_regionmax);
    }

    public void setLogRegionMax(int lg_regionmax) throws DbException {
        db_javaJNI.DbEnv_set_lg_regionmax(this.swigCPtr, lg_regionmax);
    }

    public long get_cachesize() throws DbException {
        return this.getCacheSize();
    }

    public long getCacheSize() throws DbException {
        return db_javaJNI.DbEnv_get_cachesize(this.swigCPtr);
    }

    public int get_cachesize_ncache() throws DbException {
        return this.getCacheSizeNcache();
    }

    public int getCacheSizeNcache() throws DbException {
        return db_javaJNI.DbEnv_get_cachesize_ncache(this.swigCPtr);
    }

    public long get_mp_mmapsize() throws DbException {
        return this.getMemoryPoolMapSize();
    }

    public long getMemoryPoolMapSize() throws DbException {
        return db_javaJNI.DbEnv_get_mp_mmapsize(this.swigCPtr);
    }

    public DbMpoolStat memp_stat(int flags) throws DbException {
        return this.memoryPoolStat(flags);
    }

    public DbMpoolStat memoryPoolStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_memp_stat(this.swigCPtr, flags);
    }

    public DbMpoolFStat[] memp_fstat(int flags) throws DbException {
        return this.memoryPoolFileStat(flags);
    }

    public DbMpoolFStat[] memoryPoolFileStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_memp_fstat(this.swigCPtr, flags);
    }

    public int memp_trickle(int percent) throws DbException {
        return this.memoryPoolTrickle(percent);
    }

    public int memoryPoolTrickle(int percent) throws DbException {
        return db_javaJNI.DbEnv_memp_trickle(this.swigCPtr, percent);
    }

    public int get_tx_max() throws DbException {
        return this.getTxnMax();
    }

    public int getTxnMax() throws DbException {
        return db_javaJNI.DbEnv_get_tx_max(this.swigCPtr);
    }

    public long get_tx_timestamp() throws DbException {
        return this.getTxnTimestamp();
    }

    public long getTxnTimestamp() throws DbException {
        return db_javaJNI.DbEnv_get_tx_timestamp(this.swigCPtr);
    }

    public long get_timeout(int flag) throws DbException {
        return this.getTimeout(flag);
    }

    public long getTimeout(int flag) throws DbException {
        return db_javaJNI.DbEnv_get_timeout(this.swigCPtr, flag);
    }

    public DbTxn txn_begin(DbTxn parent, int flags) throws DbException {
        return this.txnBegin(parent, flags);
    }

    public DbTxn txnBegin(DbTxn parent, int flags) throws DbException {
        long cPtr = db_javaJNI.DbEnv_txn_begin(this.swigCPtr, DbTxn.getCPtr(parent), flags);
        return cPtr == 0L ? null : new DbTxn(cPtr, false);
    }

    public void txn_checkpoint(int kbyte, int min, int flags) throws DbException {
        this.txnCheckpoint(kbyte, min, flags);
    }

    public void txnCheckpoint(int kbyte, int min, int flags) throws DbException {
        db_javaJNI.DbEnv_txn_checkpoint(this.swigCPtr, kbyte, min, flags);
    }

    public DbPreplist[] txn_recover(int count, int flags) throws DbException {
        return this.txnRecover(count, flags);
    }

    public DbPreplist[] txnRecover(int count, int flags) throws DbException {
        return db_javaJNI.DbEnv_txn_recover(this.swigCPtr, count, flags);
    }

    public DbTxnStat txn_stat(int flags) throws DbException {
        return this.txnStat(flags);
    }

    public DbTxnStat txnStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_txn_stat(this.swigCPtr, flags);
    }

    public long get_rep_limit() throws DbException {
        return this.getReplicationLimit();
    }

    public long getReplicationLimit() throws DbException {
        return db_javaJNI.DbEnv_get_rep_limit(this.swigCPtr);
    }

    public int rep_elect(int nsites, int priority, int timeout) throws DbException {
        return this.replicationElect(nsites, priority, timeout);
    }

    public int replicationElect(int nsites, int priority, int timeout) throws DbException {
        return db_javaJNI.DbEnv_rep_elect(this.swigCPtr, nsites, priority, timeout);
    }

    public int rep_process_message(Dbt control, Dbt rec, RepProcessMessage envid, DbLsn ret_lsn) throws DbException {
        return this.replicationProcessMessage(control, rec, envid, ret_lsn);
    }

    public int replicationProcessMessage(Dbt control, Dbt rec, RepProcessMessage envid, DbLsn ret_lsn) throws DbException {
        return db_javaJNI.DbEnv_rep_process_message(this.swigCPtr, control, rec, envid, DbLsn.getCPtr(ret_lsn));
    }

    public void rep_start(Dbt cdata, int flags) throws DbException {
        this.replicationStart(cdata, flags);
    }

    public void replicationStart(Dbt cdata, int flags) throws DbException {
        db_javaJNI.DbEnv_rep_start(this.swigCPtr, cdata, flags);
    }

    public DbRepStat rep_stat(int flags) throws DbException {
        return this.replicationStat(flags);
    }

    public DbRepStat replicationStat(int flags) throws DbException {
        return db_javaJNI.DbEnv_rep_stat(this.swigCPtr, flags);
    }

    public void set_rep_limit(long bytes) throws DbException {
        this.setReplicationLimit(bytes);
    }

    public void setReplicationLimit(long bytes) throws DbException {
        db_javaJNI.DbEnv_set_rep_limit(this.swigCPtr, bytes);
    }

    public void set_rep_transport(int envid, DbRepTransport send) throws DbException {
        this.setReplicationTransport(envid, send);
    }

    public void setReplicationTransport(int envid, DbRepTransport send) throws DbException {
        this.rep_transport_handler = send;
        db_javaJNI.DbEnv_set_rep_transport(this.swigCPtr, envid, this.rep_transport_handler);
    }

    public static String strerror(int error) {
        return db_javaJNI.DbEnv_strerror(error);
    }

    public static int get_version_major() {
        return DbEnv.getVersionMajor();
    }

    public static int getVersionMajor() {
        return db_javaJNI.DbEnv_get_version_major();
    }

    public static int get_version_minor() {
        return DbEnv.getVersionMinor();
    }

    public static int getVersionMinor() {
        return db_javaJNI.DbEnv_get_version_minor();
    }

    public static int get_version_patch() {
        return DbEnv.getVersionPatch();
    }

    public static int getVersionPatch() {
        return db_javaJNI.DbEnv_get_version_patch();
    }

    public static String get_version_string() {
        return DbEnv.getVersionString();
    }

    public static String getVersionString() {
        return db_javaJNI.DbEnv_get_version_string();
    }

    public static class RepProcessMessage {
        public int envid;
    }
}

