/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DbAppendRecno;
import com.sleepycat.db.DbBtreeCompare;
import com.sleepycat.db.DbBtreePrefix;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbDupCompare;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbErrcall;
import com.sleepycat.db.DbErrorHandler;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbFeedback;
import com.sleepycat.db.DbFeedbackHandler;
import com.sleepycat.db.DbHash;
import com.sleepycat.db.DbKeyRange;
import com.sleepycat.db.DbLockNotGrantedException;
import com.sleepycat.db.DbMpoolFile;
import com.sleepycat.db.DbPanicHandler;
import com.sleepycat.db.DbSecondaryKeyCreate;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sleepycat.db.db_java;
import com.sleepycat.db.db_javaJNI;
import java.io.FileNotFoundException;
import java.io.OutputStream;

public class Db {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    static final int GIGABYTE = 0x40000000;
    private Object db_ref;
    private DbEnv dbenv;
    private boolean private_dbenv;
    private DbAppendRecno append_recno_handler;
    private DbBtreeCompare bt_compare_handler;
    private DbBtreePrefix bt_prefix_handler;
    private DbDupCompare dup_compare_handler;
    private DbFeedbackHandler db_feedback_handler;
    private DbHash h_hash_handler;
    private DbSecondaryKeyCreate seckey_create_handler;
    public static final int DB_BTREE = 1;
    public static final int DB_DONOTINDEX = -30999;
    public static final int DB_FILEOPEN = -30998;
    public static final int DB_HASH = 2;
    public static final int DB_KEYEMPTY = -30997;
    public static final int DB_KEYEXIST = -30996;
    public static final int DB_LOCK_DEADLOCK = -30995;
    public static final int DB_LOCK_NOTGRANTED = -30994;
    public static final int DB_NOSERVER = -30993;
    public static final int DB_NOSERVER_HOME = -30992;
    public static final int DB_NOSERVER_ID = -30991;
    public static final int DB_NOTFOUND = -30990;
    public static final int DB_OLD_VERSION = -30989;
    public static final int DB_PAGE_NOTFOUND = -30988;
    public static final int DB_QUEUE = 4;
    public static final int DB_RECNO = 3;
    public static final int DB_REP_DUPMASTER = -30987;
    public static final int DB_REP_HANDLE_DEAD = -30986;
    public static final int DB_REP_HOLDELECTION = -30985;
    public static final int DB_REP_NEWMASTER = -30983;
    public static final int DB_REP_NEWSITE = -30982;
    public static final int DB_REP_OUTDATED = -30980;
    public static final int DB_RUNRECOVERY = -30978;
    public static final int DB_SECONDARY_BAD = -30977;
    public static final int DB_TXN_ABORT = 0;
    public static final int DB_TXN_APPLY = 1;
    public static final int DB_TXN_BACKWARD_ROLL = 3;
    public static final int DB_TXN_FORWARD_ROLL = 4;
    public static final int DB_TXN_PRINT = 8;
    public static final int DB_UNKNOWN = 5;
    public static final int DB_VERIFY_BAD = -30976;
    public static final int DB_AFTER = 1;
    public static final int DB_AGGRESSIVE = 1;
    public static final int DB_APPEND = 2;
    public static final int DB_ARCH_ABS = 1;
    public static final int DB_ARCH_DATA = 2;
    public static final int DB_ARCH_LOG = 4;
    public static final int DB_ARCH_REMOVE = 8;
    public static final int DB_AUTO_COMMIT = 0x1000000;
    public static final int DB_BEFORE = 3;
    public static final int DB_CACHED_COUNTS = 4;
    public static final int DB_CDB_ALLDB = 4096;
    public static final int DB_CHKSUM = 1;
    public static final int DB_CONSUME = 5;
    public static final int DB_CONSUME_WAIT = 6;
    public static final int DB_CREATE = 1;
    public static final int DB_CURRENT = 7;
    public static final int DB_CXX_NO_EXCEPTIONS = 2;
    public static final int DB_DBT_MALLOC = 4;
    public static final int DB_DBT_PARTIAL = 8;
    public static final int DB_DBT_REALLOC = 16;
    public static final int DB_DBT_USERMEM = 32;
    public static final int DB_DIRECT_DB = 8192;
    public static final int DB_DIRECT_LOG = 16384;
    public static final int DB_DIRTY_READ = 0x2000000;
    public static final int DB_DUP = 2;
    public static final int DB_DUPSORT = 4;
    public static final int DB_EID_BROADCAST = -1;
    public static final int DB_EID_INVALID = -2;
    public static final int DB_ENCRYPT = 8;
    public static final int DB_ENCRYPT_AES = 1;
    public static final int DB_EXCL = 4096;
    public static final int DB_FAST_STAT = 8;
    public static final int DB_FIRST = 9;
    public static final int DB_FLUSH = 1;
    public static final int DB_FORCE = 4;
    public static final int DB_GET_BOTH = 10;
    public static final int DB_GET_BOTH_RANGE = 12;
    public static final int DB_GET_RECNO = 13;
    public static final int DB_INIT_CDB = 4096;
    public static final int DB_INIT_LOCK = 8192;
    public static final int DB_INIT_LOG = 16384;
    public static final int DB_INIT_MPOOL = 32768;
    public static final int DB_INIT_REP = 65536;
    public static final int DB_INIT_TXN = 131072;
    public static final int DB_JOINENV = 262144;
    public static final int DB_JOIN_ITEM = 14;
    public static final int DB_JOIN_NOSORT = 1;
    public static final int DB_KEYFIRST = 15;
    public static final int DB_KEYLAST = 16;
    public static final int DB_LAST = 17;
    public static final int DB_LOCKDOWN = 524288;
    public static final int DB_LOCK_DEFAULT = 1;
    public static final int DB_LOCK_EXPIRE = 2;
    public static final int DB_LOCK_GET = 1;
    public static final int DB_LOCK_GET_TIMEOUT = 2;
    public static final int DB_LOCK_IREAD = 5;
    public static final int DB_LOCK_IWR = 6;
    public static final int DB_LOCK_IWRITE = 4;
    public static final int DB_LOCK_MAXLOCKS = 3;
    public static final int DB_LOCK_MINLOCKS = 4;
    public static final int DB_LOCK_MINWRITE = 5;
    public static final int DB_LOCK_NOWAIT = 1;
    public static final int DB_LOCK_OLDEST = 6;
    public static final int DB_LOCK_PUT = 4;
    public static final int DB_LOCK_PUT_ALL = 5;
    public static final int DB_LOCK_PUT_OBJ = 6;
    public static final int DB_LOCK_RANDOM = 7;
    public static final int DB_LOCK_READ = 1;
    public static final int DB_LOCK_TIMEOUT = 8;
    public static final int DB_LOCK_WRITE = 2;
    public static final int DB_LOCK_YOUNGEST = 8;
    public static final int DB_LOG_AUTOREMOVE = 32768;
    public static final int DB_MPOOL_NOFILE = 1;
    public static final int DB_MULTIPLE = 0x4000000;
    public static final int DB_MULTIPLE_KEY = 0x8000000;
    public static final int DB_NEXT = 18;
    public static final int DB_NEXT_DUP = 19;
    public static final int DB_NEXT_NODUP = 20;
    public static final int DB_NODUPDATA = 21;
    public static final int DB_NOLOCKING = 65536;
    public static final int DB_NOMMAP = 8;
    public static final int DB_NOORDERCHK = 2;
    public static final int DB_NOOVERWRITE = 22;
    public static final int DB_NOPANIC = 131072;
    public static final int DB_NOSYNC = 23;
    public static final int DB_ORDERCHKONLY = 4;
    public static final int DB_OVERWRITE = 262144;
    public static final int DB_PANIC_ENVIRONMENT = 524288;
    public static final int DB_POSITION = 24;
    public static final int DB_PREV = 25;
    public static final int DB_PREV_NODUP = 26;
    public static final int DB_PRINTABLE = 32;
    public static final int DB_PRIORITY_DEFAULT = 3;
    public static final int DB_PRIORITY_HIGH = 4;
    public static final int DB_PRIORITY_LOW = 2;
    public static final int DB_PRIORITY_VERY_HIGH = 5;
    public static final int DB_PRIORITY_VERY_LOW = 1;
    public static final int DB_PRIVATE = 0x100000;
    public static final int DB_RDONLY = 16;
    public static final int DB_RECNUM = 16;
    public static final int DB_RECORDCOUNT = 27;
    public static final int DB_RECOVER = 32;
    public static final int DB_RECOVER_FATAL = 0x200000;
    public static final int DB_REGION_INIT = 0x100000;
    public static final int DB_RENUMBER = 32;
    public static final int DB_REP_CLIENT = 1;
    public static final int DB_REP_ISPERM = -30984;
    public static final int DB_REP_LOGSONLY = 2;
    public static final int DB_REP_MASTER = 4;
    public static final int DB_REP_NOBUFFER = 1;
    public static final int DB_REP_NOTPERM = -30981;
    public static final int DB_REP_PERMANENT = 2;
    public static final int DB_REP_UNAVAIL = -30979;
    public static final int DB_REVSPLITOFF = 64;
    public static final int DB_RMW = 0x10000000;
    public static final int DB_RPCCLIENT = 1;
    public static final int DB_SALVAGE = 64;
    public static final int DB_SET = 28;
    public static final int DB_SET_LOCK_TIMEOUT = 29;
    public static final int DB_SET_RANGE = 30;
    public static final int DB_SET_RECNO = 31;
    public static final int DB_SET_TXN_TIMEOUT = 33;
    public static final int DB_SNAPSHOT = 128;
    public static final int DB_STAT_CLEAR = 1;
    public static final int DB_SYSTEM_MEM = 0x400000;
    public static final int DB_THREAD = 64;
    public static final int DB_TIME_NOTGRANTED = 0x200000;
    public static final int DB_TRUNCATE = 128;
    public static final int DB_TXN_NOSYNC = 256;
    public static final int DB_TXN_NOT_DURABLE = 512;
    public static final int DB_TXN_NOWAIT = 4096;
    public static final int DB_TXN_SYNC = 8192;
    public static final int DB_TXN_WRITE_NOSYNC = 0x400000;
    public static final int DB_UPGRADE = 1;
    public static final int DB_USE_ENVIRON = 1024;
    public static final int DB_USE_ENVIRON_ROOT = 2048;
    public static final int DB_VERB_CHKPOINT = 1;
    public static final int DB_VERB_DEADLOCK = 2;
    public static final int DB_VERB_RECOVERY = 4;
    public static final int DB_VERB_REPLICATION = 8;
    public static final int DB_VERB_WAITSFOR = 16;
    public static final int DB_VERIFY = 2;
    public static final int DB_VERSION_MAJOR = 4;
    public static final int DB_VERSION_MINOR = 2;
    public static final int DB_VERSION_PATCH = 52;
    public static final int DB_WRITECURSOR = 35;
    public static final int DB_XA_CREATE = 2;
    public static final int DB_XIDDATASIZE = 128;
    public static final int DB_YIELDCPU = 0x800000;

    protected Db(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected Db() {
        this(0L, false);
    }

    protected void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(Db obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    private void initialize(DbEnv dbenv) {
        if (dbenv == null) {
            this.private_dbenv = true;
            dbenv = db_java.getDbEnv0(this);
            dbenv.initialize();
        }
        this.dbenv = dbenv;
        this.db_ref = db_java.initDbRef0(this, this);
    }

    private void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.db_ref);
        this.db_ref = null;
        if (this.private_dbenv) {
            this.dbenv.cleanup();
        }
        this.dbenv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int flags) throws DbException {
        try {
            this.close0(flags);
            Object var3_2 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public DbEnv get_env() throws DbException {
        return this.getDbEnv();
    }

    public DbEnv getDbEnv() throws DbException {
        return this.dbenv;
    }

    private final void handle_append_recno(Dbt data, int recno) throws DbException {
        this.append_recno_handler.dbAppendRecno(this, data, recno);
    }

    private final int handle_bt_compare(Dbt dbt1, Dbt dbt2) {
        return this.bt_compare_handler.compare(this, dbt1, dbt2);
    }

    private final int handle_bt_prefix(Dbt dbt1, Dbt dbt2) {
        return this.bt_prefix_handler.prefix(this, dbt1, dbt2);
    }

    private final void handle_db_feedback(int opcode, int percent) {
        this.db_feedback_handler.feedback(this, opcode, percent);
    }

    private final int handle_dup_compare(Dbt dbt1, Dbt dbt2) {
        return this.dup_compare_handler.compareDuplicates(this, dbt1, dbt2);
    }

    private final int handle_h_hash(byte[] data, int len) {
        return this.h_hash_handler.hash(this, data, len);
    }

    private final int handle_seckey_create(Dbt key, Dbt data, Dbt result) throws DbException {
        return this.seckey_create_handler.secondaryKeyCreate(this, key, data, result);
    }

    public boolean isEncrypted() throws DbException {
        return this.get_encrypt_flags() != 0;
    }

    public void open(DbTxn txnid, String file, String database, int type, int flags, int mode) throws DbException, FileNotFoundException, DbDeadlockException, DbLockNotGrantedException {
        this.open0(txnid, file, database, type, flags |= DB_THREAD, mode);
    }

    public int pget(DbTxn txnid, Dbt key, Dbt pkey, Dbt data, int flags) throws DbException {
        return this.get(txnid, key, pkey, data, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String file, String database, int flags) throws DbException, FileNotFoundException {
        try {
            this.remove0(file, database, flags);
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rename(String file, String database, String newname, int flags) throws DbException, FileNotFoundException {
        try {
            this.rename0(file, database, newname, flags);
            Object var6_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verify(String file, String database, OutputStream outfile, int flags) throws DbException, FileNotFoundException {
        try {
            this.verify0(file, database, outfile, flags);
            Object var6_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void set_cachesize(int gbytes, int bytes, int ncache) throws DbException {
        this.set_cachesize((long)gbytes * 0x40000000L + (long)bytes, ncache);
    }

    public void set_errcall(DbErrcall db_errcall_fcn) {
        final DbErrcall ferrcall = db_errcall_fcn;
        try {
            this.dbenv.setErrorHandler(new DbErrorHandler(){

                public void error(String prefix, String str) {
                    ferrcall.errcall(prefix, str);
                }
            });
        }
        catch (DbException dbe) {
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbe);
            dbe.printStackTrace(System.err);
        }
    }

    public void setErrorHandler(DbErrorHandler db_errcall_fcn) throws DbException {
        this.dbenv.setErrorHandler(db_errcall_fcn);
    }

    public String get_errpfx() {
        return this.getErrorPrefix();
    }

    public String getErrorPrefix() {
        return this.dbenv.get_errpfx();
    }

    public void set_errpfx(String errpfx) {
        this.setErrorPrefix(errpfx);
    }

    public void setErrorPrefix(String errpfx) {
        this.dbenv.set_errpfx(errpfx);
    }

    public void set_error_stream(OutputStream stream) {
        this.setErrorStream(stream);
    }

    public void setErrorStream(OutputStream stream) {
        this.dbenv.set_error_stream(stream);
    }

    public void set_feedback(DbFeedback feedback) throws DbException {
        final DbFeedback ffeedback = feedback;
        this.setFeedbackHandler(new DbFeedbackHandler(){

            public void feedback(Db db, int opcode, int percent) {
                ffeedback.feedback(db, opcode, percent);
            }
        });
    }

    public void setPanicHandler(DbPanicHandler db_panic_fcn) throws DbException {
        this.dbenv.setPanicHandler(db_panic_fcn);
    }

    public Db(DbEnv dbenv, int flags) throws DbException {
        this(db_javaJNI.new_Db(DbEnv.getCPtr(dbenv), flags), true);
        this.initialize(dbenv);
    }

    public void associate(DbTxn txnid, Db secondary, DbSecondaryKeyCreate callback, int flags) throws DbException {
        secondary.seckey_create_handler = callback;
        db_javaJNI.Db_associate(this.swigCPtr, DbTxn.getCPtr(txnid), Db.getCPtr(secondary), secondary.seckey_create_handler, flags);
    }

    int close0(int flags) {
        return db_javaJNI.Db_close0(this.swigCPtr, flags);
    }

    public Dbc cursor(DbTxn txnid, int flags) throws DbException {
        long cPtr = db_javaJNI.Db_cursor(this.swigCPtr, DbTxn.getCPtr(txnid), flags);
        return cPtr == 0L ? null : new Dbc(cPtr, false);
    }

    public int del(DbTxn txnid, Dbt key, int flags) throws DbException {
        return this.delete(txnid, key, flags);
    }

    public int delete(DbTxn txnid, Dbt key, int flags) throws DbException {
        return db_javaJNI.Db_del(this.swigCPtr, DbTxn.getCPtr(txnid), key, flags);
    }

    public void err(int error, String message) {
        db_javaJNI.Db_err(this.swigCPtr, error, message);
    }

    public void errx(String message) {
        db_javaJNI.Db_errx(this.swigCPtr, message);
    }

    public int get(DbTxn txnid, Dbt key, Dbt data, int flags) throws DbException {
        return db_javaJNI.Db_get__SWIG_0(this.swigCPtr, DbTxn.getCPtr(txnid), key, data, flags);
    }

    public boolean get_byteswapped() throws DbException {
        return this.isByteSwapped();
    }

    public boolean isByteSwapped() throws DbException {
        return db_javaJNI.Db_get_byteswapped(this.swigCPtr);
    }

    public long get_cachesize() throws DbException {
        return this.getCacheSize();
    }

    public long getCacheSize() throws DbException {
        return db_javaJNI.Db_get_cachesize(this.swigCPtr);
    }

    public int get_cachesize_ncache() throws DbException {
        return this.getCacheSizeNcache();
    }

    public int getCacheSizeNcache() throws DbException {
        return db_javaJNI.Db_get_cachesize_ncache(this.swigCPtr);
    }

    public String get_filename() throws DbException {
        return this.getFileName();
    }

    public String getFileName() throws DbException {
        return db_javaJNI.Db_get_filename(this.swigCPtr);
    }

    public String get_dbname() throws DbException {
        return this.getDatabaseName();
    }

    public String getDatabaseName() throws DbException {
        return db_javaJNI.Db_get_dbname(this.swigCPtr);
    }

    public int get_encrypt_flags() throws DbException {
        return this.getEncryptFlags();
    }

    public int getEncryptFlags() throws DbException {
        return db_javaJNI.Db_get_encrypt_flags(this.swigCPtr);
    }

    public int get_flags() throws DbException {
        return this.getFlags();
    }

    public int getFlags() throws DbException {
        return db_javaJNI.Db_get_flags(this.swigCPtr);
    }

    public int get_lorder() throws DbException {
        return this.getByteOrder();
    }

    public int getByteOrder() throws DbException {
        return db_javaJNI.Db_get_lorder(this.swigCPtr);
    }

    public DbMpoolFile get_mpf() throws DbException {
        long cPtr = db_javaJNI.Db_get_mpf(this.swigCPtr);
        return cPtr == 0L ? null : new DbMpoolFile(cPtr, false);
    }

    public int get_open_flags() throws DbException {
        return this.getOpenFlags();
    }

    public int getOpenFlags() throws DbException {
        return db_javaJNI.Db_get_open_flags(this.swigCPtr);
    }

    public int get_pagesize() throws DbException {
        return this.getPageSize();
    }

    public int getPageSize() throws DbException {
        return db_javaJNI.Db_get_pagesize(this.swigCPtr);
    }

    public int get_bt_minkey() throws DbException {
        return this.getBtreeMinKey();
    }

    public int getBtreeMinKey() throws DbException {
        return db_javaJNI.Db_get_bt_minkey(this.swigCPtr);
    }

    public int get_h_ffactor() throws DbException {
        return this.getHashFillFactor();
    }

    public int getHashFillFactor() throws DbException {
        return db_javaJNI.Db_get_h_ffactor(this.swigCPtr);
    }

    public int get_h_nelem() throws DbException {
        return this.getHashNumElements();
    }

    public int getHashNumElements() throws DbException {
        return db_javaJNI.Db_get_h_nelem(this.swigCPtr);
    }

    public int get_re_delim() throws DbException {
        return this.getRecordDelimiter();
    }

    public int getRecordDelimiter() throws DbException {
        return db_javaJNI.Db_get_re_delim(this.swigCPtr);
    }

    public int get_re_len() throws DbException {
        return this.getRecordLength();
    }

    public int getRecordLength() throws DbException {
        return db_javaJNI.Db_get_re_len(this.swigCPtr);
    }

    public int get_re_pad() throws DbException {
        return this.getRecordPad();
    }

    public int getRecordPad() throws DbException {
        return db_javaJNI.Db_get_re_pad(this.swigCPtr);
    }

    public String get_re_source() throws DbException {
        return this.getRecordSource();
    }

    public String getRecordSource() throws DbException {
        return db_javaJNI.Db_get_re_source(this.swigCPtr);
    }

    public int get_q_extentsize() throws DbException {
        return this.getQueueExtentSize();
    }

    public int getQueueExtentSize() throws DbException {
        return db_javaJNI.Db_get_q_extentsize(this.swigCPtr);
    }

    public int get_flags_raw() throws DbException {
        return db_javaJNI.Db_get_flags_raw(this.swigCPtr);
    }

    public boolean get_transactional() throws DbException {
        return this.isTransactional();
    }

    public boolean isTransactional() throws DbException {
        return db_javaJNI.Db_get_transactional(this.swigCPtr);
    }

    public int get_type() throws DbException {
        return this.getDbType();
    }

    public int getDbType() throws DbException {
        return db_javaJNI.Db_get_type(this.swigCPtr);
    }

    public Dbc join(Dbc[] curslist, int flags) throws DbException {
        long cPtr = db_javaJNI.Db_join(this.swigCPtr, curslist, flags);
        return cPtr == 0L ? null : new Dbc(cPtr, true);
    }

    public void key_range(DbTxn txnid, Dbt key, DbKeyRange key_range, int flags) throws DbException {
        this.keyRange(txnid, key, key_range, flags);
    }

    public void keyRange(DbTxn txnid, Dbt key, DbKeyRange key_range, int flags) throws DbException {
        db_javaJNI.Db_key_range(this.swigCPtr, DbTxn.getCPtr(txnid), key, key_range, flags);
    }

    void open0(DbTxn txnid, String file, String database, int type, int flags, int mode) {
        db_javaJNI.Db_open0(this.swigCPtr, DbTxn.getCPtr(txnid), file, database, type, flags, mode);
    }

    public int get(DbTxn txnid, Dbt key, Dbt pkey, Dbt data, int flags) throws DbException {
        return db_javaJNI.Db_get__SWIG_1(this.swigCPtr, DbTxn.getCPtr(txnid), key, pkey, data, flags);
    }

    public int put(DbTxn txnid, Dbt key, Dbt data, int flags) throws DbException {
        return db_javaJNI.Db_put(this.swigCPtr, DbTxn.getCPtr(txnid), key, data, flags);
    }

    void remove0(String file, String database, int flags) {
        db_javaJNI.Db_remove0(this.swigCPtr, file, database, flags);
    }

    void rename0(String file, String database, String newname, int flags) {
        db_javaJNI.Db_rename0(this.swigCPtr, file, database, newname, flags);
    }

    public void set_append_recno(DbAppendRecno db_append_recno_fcn) throws DbException {
        this.setAppendRecno(db_append_recno_fcn);
    }

    public void setAppendRecno(DbAppendRecno db_append_recno_fcn) throws DbException {
        this.append_recno_handler = db_append_recno_fcn;
        db_javaJNI.Db_set_append_recno(this.swigCPtr, this.append_recno_handler);
    }

    public void set_bt_compare(DbBtreeCompare bt_compare_fcn) throws DbException {
        this.setBtreeCompare(bt_compare_fcn);
    }

    public void setBtreeCompare(DbBtreeCompare bt_compare_fcn) throws DbException {
        this.bt_compare_handler = bt_compare_fcn;
        db_javaJNI.Db_set_bt_compare(this.swigCPtr, this.bt_compare_handler);
    }

    public void set_bt_maxkey(int maxkey) throws DbException {
        db_javaJNI.Db_set_bt_maxkey(this.swigCPtr, maxkey);
    }

    public void set_bt_minkey(int bt_minkey) throws DbException {
        this.setBtreeMinKey(bt_minkey);
    }

    public void setBtreeMinKey(int bt_minkey) throws DbException {
        db_javaJNI.Db_set_bt_minkey(this.swigCPtr, bt_minkey);
    }

    public void set_bt_prefix(DbBtreePrefix bt_prefix_fcn) throws DbException {
        this.setBtreePrefix(bt_prefix_fcn);
    }

    public void setBtreePrefix(DbBtreePrefix bt_prefix_fcn) throws DbException {
        this.bt_prefix_handler = bt_prefix_fcn;
        db_javaJNI.Db_set_bt_prefix(this.swigCPtr, this.bt_prefix_handler);
    }

    public void set_cachesize(long bytes, int ncache) throws DbException {
        this.setCacheSize(bytes, ncache);
    }

    public void setCacheSize(long bytes, int ncache) throws DbException {
        db_javaJNI.Db_set_cachesize(this.swigCPtr, bytes, ncache);
    }

    public void set_dup_compare(DbDupCompare dup_compare_fcn) throws DbException {
        this.setDuplicateCompare(dup_compare_fcn);
    }

    public void setDuplicateCompare(DbDupCompare dup_compare_fcn) throws DbException {
        this.dup_compare_handler = dup_compare_fcn;
        db_javaJNI.Db_set_dup_compare(this.swigCPtr, this.dup_compare_handler);
    }

    public void set_encrypt(String passwd, int flags) throws DbException {
        this.setEncrypted(passwd, flags);
    }

    public void setEncrypted(String passwd, int flags) throws DbException {
        db_javaJNI.Db_set_encrypt(this.swigCPtr, passwd, flags);
    }

    public void setFeedbackHandler(DbFeedbackHandler db_feedback_fcn) throws DbException {
        this.db_feedback_handler = db_feedback_fcn;
        db_javaJNI.Db_setFeedbackHandler(this.swigCPtr, this.db_feedback_handler);
    }

    public void set_flags(int flags) throws DbException {
        this.setFlags(flags);
    }

    public void setFlags(int flags) throws DbException {
        db_javaJNI.Db_set_flags(this.swigCPtr, flags);
    }

    public void set_h_ffactor(int h_ffactor) throws DbException {
        this.setHashFillFactor(h_ffactor);
    }

    public void setHashFillFactor(int h_ffactor) throws DbException {
        db_javaJNI.Db_set_h_ffactor(this.swigCPtr, h_ffactor);
    }

    public void set_h_hash(DbHash h_hash_fcn) throws DbException {
        this.setHash(h_hash_fcn);
    }

    public void setHash(DbHash h_hash_fcn) throws DbException {
        this.h_hash_handler = h_hash_fcn;
        db_javaJNI.Db_set_h_hash(this.swigCPtr, this.h_hash_handler);
    }

    public void set_h_nelem(int h_nelem) throws DbException {
        this.setHashNumElements(h_nelem);
    }

    public void setHashNumElements(int h_nelem) throws DbException {
        db_javaJNI.Db_set_h_nelem(this.swigCPtr, h_nelem);
    }

    public void set_lorder(int lorder) throws DbException {
        this.setByteOrder(lorder);
    }

    public void setByteOrder(int lorder) throws DbException {
        db_javaJNI.Db_set_lorder(this.swigCPtr, lorder);
    }

    public void set_pagesize(long pagesize) throws DbException {
        this.setPageSize(pagesize);
    }

    public void setPageSize(long pagesize) throws DbException {
        db_javaJNI.Db_set_pagesize(this.swigCPtr, pagesize);
    }

    public void set_re_delim(int re_delim) throws DbException {
        this.setRecordDelimiter(re_delim);
    }

    public void setRecordDelimiter(int re_delim) throws DbException {
        db_javaJNI.Db_set_re_delim(this.swigCPtr, re_delim);
    }

    public void set_re_len(int re_len) throws DbException {
        this.setRecordLength(re_len);
    }

    public void setRecordLength(int re_len) throws DbException {
        db_javaJNI.Db_set_re_len(this.swigCPtr, re_len);
    }

    public void set_re_pad(int re_pad) throws DbException {
        this.setRecordPad(re_pad);
    }

    public void setRecordPad(int re_pad) throws DbException {
        db_javaJNI.Db_set_re_pad(this.swigCPtr, re_pad);
    }

    public void set_re_source(String source) throws DbException {
        this.setRecordSource(source);
    }

    public void setRecordSource(String source) throws DbException {
        db_javaJNI.Db_set_re_source(this.swigCPtr, source);
    }

    public void set_q_extentsize(int extentsize) throws DbException {
        this.setQueueExtentSize(extentsize);
    }

    public void setQueueExtentSize(int extentsize) throws DbException {
        db_javaJNI.Db_set_q_extentsize(this.swigCPtr, extentsize);
    }

    public Object stat(int flags) throws DbException {
        return db_javaJNI.Db_stat(this.swigCPtr, flags);
    }

    public void sync(int flags) throws DbException {
        db_javaJNI.Db_sync(this.swigCPtr, flags);
    }

    public int truncate(DbTxn txnid, int flags) throws DbException {
        return db_javaJNI.Db_truncate(this.swigCPtr, DbTxn.getCPtr(txnid), flags);
    }

    public void upgrade(String file, int flags) throws DbException {
        db_javaJNI.Db_upgrade(this.swigCPtr, file, flags);
    }

    void verify0(String file, String database, OutputStream outfile, int flags) {
        db_javaJNI.Db_verify0(this.swigCPtr, file, database, outfile, flags);
    }
}

