/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastOutputStream
extends OutputStream {
    public static final int DEFAULT_INIT_SIZE = 100;
    public static final int DEFAULT_BUMP_SIZE = 100;
    private int len;
    private int bumpLen;
    private byte[] buf;

    public FastOutputStream() {
        this.buf = new byte[100];
        this.bumpLen = 100;
    }

    public FastOutputStream(int initialSize) {
        this.buf = new byte[initialSize];
        this.bumpLen = 100;
    }

    public FastOutputStream(int initialSize, int bumpSize) {
        this.buf = new byte[initialSize];
        this.bumpLen = bumpSize;
    }

    public FastOutputStream(byte[] buffer) {
        this.buf = buffer;
        this.bumpLen = 100;
    }

    public FastOutputStream(byte[] buffer, int bumpSize) {
        this.buf = buffer;
        this.bumpLen = bumpSize;
    }

    public int size() {
        return this.len;
    }

    public void reset() {
        this.len = 0;
    }

    public void write(int b) throws IOException {
        if (this.len + 1 > this.buf.length) {
            this.bump(1);
        }
        this.buf[this.len++] = (byte)b;
    }

    public void write(byte[] fromBuf) throws IOException {
        int needed = this.len + fromBuf.length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        int i = 0;
        while (i < fromBuf.length) {
            this.buf[this.len++] = fromBuf[i];
            ++i;
        }
    }

    public void write(byte[] fromBuf, int offset, int length) throws IOException {
        int needed = this.len + length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        int fromLen = offset + length;
        int i = offset;
        while (i < fromLen) {
            this.buf[this.len++] = fromBuf[i];
            ++i;
        }
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.len);
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.len, encoding);
    }

    public byte[] toByteArray() {
        byte[] toBuf = new byte[this.len];
        int i = 0;
        while (i < this.len) {
            toBuf[i] = this.buf[i];
            ++i;
        }
        return toBuf;
    }

    public void toByteArray(byte[] toBuf, int offset) {
        int toLen = toBuf.length > this.len ? this.len : toBuf.length;
        int i = offset;
        while (i < toLen) {
            toBuf[i] = this.buf[i];
            ++i;
        }
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.len;
    }

    public void makeSpace(int sizeNeeded) {
        int needed = this.len + sizeNeeded - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
    }

    public void addSize(int sizeAdded) {
        this.len += sizeAdded;
    }

    private void bump(int needed) {
        byte[] toBuf = new byte[this.buf.length + needed + this.bumpLen];
        int i = 0;
        while (i < this.len) {
            toBuf[i] = this.buf[i];
            ++i;
        }
        this.buf = toBuf;
    }
}

