/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.util;

import java.io.IOException;
import java.io.InputStream;

public class FastInputStream
extends InputStream {
    protected int len;
    protected int off;
    protected int mark;
    protected byte[] buf;

    public FastInputStream(byte[] buffer) {
        this.buf = buffer;
        this.len = buffer.length;
    }

    public FastInputStream(byte[] buffer, int offset, int length) {
        this.buf = buffer;
        this.off = offset;
        this.len = length;
    }

    public int available() {
        return this.len - this.off;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int pos) {
        this.mark = pos;
    }

    public void reset() {
        this.off = this.mark;
    }

    public long skip(long count) {
        int myCount = (int)count;
        if (myCount + this.off > this.len) {
            myCount = this.len - this.off;
        }
        this.off += myCount;
        return myCount;
    }

    public int read() throws IOException {
        return this.off < this.len ? this.buf[this.off++] & 0xFF : -1;
    }

    public int read(byte[] toBuf) throws IOException {
        return this.read(toBuf, 0, toBuf.length);
    }

    public int read(byte[] toBuf, int offset, int length) throws IOException {
        int avail = this.len - this.off;
        if (avail <= 0) {
            return -1;
        }
        if (length > avail) {
            length = avail;
        }
        int i = 0;
        while (i < length) {
            toBuf[offset++] = this.buf[this.off++];
            ++i;
        }
        return length;
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return this.off;
    }

    public int getBufferLength() {
        return this.len;
    }
}

