/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Set;

public class StoredValueSet
extends StoredCollection
implements Set {
    private boolean isSingleKey;

    public StoredValueSet(DataStore store, DataBinding valueBinding, boolean writeAllowed) {
        super(new DataView(store, null, null, valueBinding, null, writeAllowed));
    }

    public StoredValueSet(DataStore store, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(store, null, null, null, valueEntityBinding, writeAllowed));
    }

    public StoredValueSet(DataIndex index, DataBinding valueBinding, boolean writeAllowed) {
        super(new DataView(null, index, null, valueBinding, null, writeAllowed));
    }

    public StoredValueSet(DataIndex index, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(null, index, null, null, valueEntityBinding, writeAllowed));
    }

    StoredValueSet(DataView valueSetView) {
        super(valueSetView);
    }

    StoredValueSet(DataView valueSetView, boolean isSingleKey) {
        super(valueSetView);
        this.isSingleKey = isSingleKey;
    }

    public boolean add(Object entity) {
        if (this.view.getIndex() != null) {
            throw new UnsupportedOperationException("add() not allowed with index");
        }
        if (this.isSingleKey) {
            boolean doAutoCommit = this.beginAutoCommit();
            try {
                int err = this.view.addValue(this.view.getSingleKeyThang(), entity, Db.DB_NODUPDATA);
                this.commitAutoCommit(doAutoCommit);
                return err == 0;
            }
            catch (Exception e) {
                throw this.handleException(e, doAutoCommit);
            }
        }
        if (this.view.getValueEntityBinding() == null) {
            throw new UnsupportedOperationException("add() requires entity binding");
        }
        return this.add(null, entity);
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public boolean remove(Object value) {
        return this.removeValue(value);
    }

    public int size() {
        int n;
        DataCursor cursor;
        block6: {
            if (!this.isSingleKey) {
                return super.size();
            }
            cursor = null;
            cursor = new DataCursor(this.view, false);
            int err = cursor.get(null, null, Db.DB_FIRST, false);
            if (err != 0) break block6;
            int n2 = cursor.count();
            Object var5_6 = null;
            this.closeCursor(cursor);
            return n2;
        }
        try {
            n = 0;
            Object var5_7 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return n;
    }

    Object makeIteratorData(StoredIterator iterator, DataCursor cursor) throws DbException, IOException {
        return cursor.getCurrentValue();
    }

    boolean hasValues() {
        return true;
    }
}

