/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredEntrySet;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredKeySet;
import com.sleepycat.bdb.collection.StoredSortedEntrySet;
import com.sleepycat.bdb.collection.StoredSortedKeySet;
import com.sleepycat.bdb.collection.StoredSortedValueSet;
import com.sleepycat.bdb.collection.StoredValueSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredMap
extends StoredContainer
implements Map {
    private StoredKeySet keySet;
    private StoredEntrySet entrySet;
    private StoredValueSet valueSet;

    public StoredMap(DataStore store, DataBinding keyBinding, DataBinding valueBinding, boolean writeAllowed) {
        super(new DataView(store, null, keyBinding, valueBinding, null, writeAllowed));
    }

    protected Object clone() throws CloneNotSupportedException {
        StoredMap other = (StoredMap)super.clone();
        other.keySet = null;
        other.entrySet = null;
        other.valueSet = null;
        return other;
    }

    public StoredMap(DataStore store, DataBinding keyBinding, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(store, null, keyBinding, null, valueEntityBinding, writeAllowed));
    }

    public StoredMap(DataIndex index, DataBinding keyBinding, DataBinding valueBinding, boolean writeAllowed) {
        super(new DataView(null, index, keyBinding, valueBinding, null, writeAllowed));
    }

    public StoredMap(DataIndex index, DataBinding keyBinding, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(null, index, keyBinding, null, valueEntityBinding, writeAllowed));
    }

    StoredMap(DataView view) {
        super(view);
    }

    public Object get(Object key) {
        return super.get(key);
    }

    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public Object append(Object value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] key = new Object[1];
            this.view.append(value, key, null);
            this.commitAutoCommit(doAutoCommit);
            return key[0];
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public Object remove(Object key) {
        Object[] oldVal = new Object[1];
        this.removeKey(key, oldVal);
        return oldVal[0];
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public void putAll(Map map) {
        boolean doAutoCommit = this.beginAutoCommit();
        Iterator entries = null;
        try {
            entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.put(entry.getKey(), entry.getValue());
            }
            StoredIterator.close(entries);
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            StoredIterator.close(entries);
            throw this.handleException(e, doAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        if (this.keySet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.keySet == null) {
                    DataView newView = this.view.keySetView();
                    this.keySet = this.isOrdered() ? new StoredSortedKeySet(newView) : new StoredKeySet(newView);
                }
            }
        }
        return this.keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        if (this.entrySet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.entrySet == null) {
                    this.entrySet = this.isOrdered() ? new StoredSortedEntrySet(this.view) : new StoredEntrySet(this.view);
                }
            }
        }
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        if (this.valueSet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.valueSet == null) {
                    DataView newView = this.view.valueSetView();
                    this.valueSet = this.isOrdered() && newView.canDeriveKeyFromValue() ? new StoredSortedValueSet(newView) : new StoredValueSet(newView);
                }
            }
        }
        return this.valueSet;
    }

    public Collection duplicates(Object key) {
        try {
            DataView newView = this.view.valueSetView(key);
            return new StoredValueSet(newView, true);
        }
        catch (KeyRangeException e) {
            return Collections.EMPTY_SET;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Map) {
            return this.entrySet().equals(((Map)other).entrySet());
        }
        return false;
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

