/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StoredList
extends StoredCollection
implements List {
    private static final DataBinding DEFAULT_KEY_BINDING = new IndexKeyBinding(1);
    private int baseIndex = 1;
    private boolean isSubList;

    public StoredList(DataStore store, DataBinding valueBinding, boolean writeAllowed) {
        super(new DataView(store, null, DEFAULT_KEY_BINDING, valueBinding, null, writeAllowed));
    }

    public StoredList(DataStore store, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(store, null, DEFAULT_KEY_BINDING, null, valueEntityBinding, writeAllowed));
    }

    public StoredList(DataIndex index, DataBinding valueBinding, boolean writeAllowed) {
        super(new DataView(null, index, DEFAULT_KEY_BINDING, valueBinding, null, writeAllowed));
    }

    public StoredList(DataIndex index, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(null, index, DEFAULT_KEY_BINDING, null, valueEntityBinding, writeAllowed));
    }

    private StoredList(DataView view, int baseIndex) {
        super(view);
        this.baseIndex = baseIndex;
        this.isSubList = true;
    }

    public void add(int index, Object value) {
        this.checkIterAddAllowed();
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            int err = cursor.get(new Long(index), null, Db.DB_SET, false);
            if (err == 0) {
                cursor.put(null, value, Db.DB_BEFORE, null);
                this.closeCursor(cursor);
            } else {
                this.closeCursor(cursor);
                cursor = null;
                this.view.append(value, null, null);
            }
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean add(Object value) {
        this.checkIterAddAllowed();
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            this.view.append(value, null, null);
            this.commitAutoCommit(doAutoCommit);
            return true;
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public int append(Object value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] key = new Object[1];
            this.view.append(value, key, null);
            this.commitAutoCommit(doAutoCommit);
            return ((Number)key[0]).intValue();
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("cannot add to subList");
        }
        if (!this.view.getDb().areKeysRenumbered()) {
            throw new UnsupportedOperationException("requires renumbered keys");
        }
    }

    public boolean addAll(int index, Collection coll) {
        this.checkIterAddAllowed();
        DataCursor cursor = null;
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            i = coll.iterator();
            if (!i.hasNext()) {
                return false;
            }
            cursor = new DataCursor(this.view, true);
            int err = cursor.get(new Long(index), null, Db.DB_SET, false);
            if (err == 0) {
                while (i.hasNext()) {
                    cursor.put(null, i.next(), Db.DB_BEFORE, null);
                }
                this.closeCursor(cursor);
            } else {
                this.closeCursor(cursor);
                cursor = null;
                while (i.hasNext()) {
                    this.view.append(i.next(), null, null);
                }
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return true;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public Object get(int index) {
        return super.get(new Long(index));
    }

    public int indexOf(Object value) {
        return this.indexOf(value, true);
    }

    public int lastIndexOf(Object value) {
        return this.indexOf(value, false);
    }

    private int indexOf(Object value, boolean findFirst) {
        int n;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            int err = cursor.find(value, findFirst);
            n = err == 0 ? cursor.getCurrentRecordNumber() - this.baseIndex : -1;
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return n;
    }

    int getIndexOffset() {
        return this.baseIndex;
    }

    public ListIterator listIterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public ListIterator listIterator(int index) {
        StoredIterator i = this.iterator(this.isWriteAllowed());
        if (i.moveToIndex(index)) {
            return i;
        }
        i.close();
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public Object remove(int index) {
        try {
            Object[] oldVal = new Object[1];
            this.removeKey(new Long(index), oldVal);
            return oldVal[0];
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public boolean remove(Object value) {
        return this.removeValue(value);
    }

    public Object set(int index, Object value) {
        try {
            return this.put(new Long(index), value);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(fromIndex));
        }
        try {
            int newBaseIndex = this.baseIndex + fromIndex;
            return new StoredList(this.view.subView(new Long(fromIndex), true, new Long(toIndex), false, new IndexKeyBinding(newBaseIndex)), newBaseIndex);
        }
        catch (KeyRangeException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object other) {
        boolean bl;
        ListIterator i2;
        ListIterator i1;
        block14: {
            boolean bl2;
            block9: {
                boolean bl3;
                block13: {
                    boolean bl4;
                    block12: {
                        boolean bl5;
                        block11: {
                            boolean bl6;
                            block10: {
                                if (!(other instanceof List)) {
                                    return false;
                                }
                                List otherList = (List)other;
                                i1 = null;
                                i2 = null;
                                try {
                                    block8: {
                                        i1 = this.listIterator();
                                        i2 = otherList.listIterator();
                                        while (true) {
                                            if (!i1.hasNext()) {
                                                if (!i2.hasNext()) break block8;
                                                bl2 = false;
                                                break block9;
                                            }
                                            if (!i2.hasNext()) {
                                                bl6 = false;
                                                Object var11_9 = null;
                                                break block10;
                                            }
                                            if (i1.nextIndex() != i2.nextIndex()) {
                                                bl5 = false;
                                                break block11;
                                            }
                                            Object o1 = i1.next();
                                            Object o2 = i2.next();
                                            if (o1 == null) {
                                                if (o2 == null) continue;
                                                bl4 = false;
                                                break block12;
                                            }
                                            if (!o1.equals(o2)) break;
                                        }
                                        bl3 = false;
                                        break block13;
                                    }
                                    bl = true;
                                    break block14;
                                }
                                catch (Throwable throwable) {
                                    Object var11_15 = null;
                                    StoredIterator.close(i1);
                                    StoredIterator.close(i2);
                                    throw throwable;
                                }
                            }
                            StoredIterator.close(i1);
                            StoredIterator.close(i2);
                            return bl6;
                        }
                        Object var11_10 = null;
                        StoredIterator.close(i1);
                        StoredIterator.close(i2);
                        return bl5;
                    }
                    Object var11_11 = null;
                    StoredIterator.close(i1);
                    StoredIterator.close(i2);
                    return bl4;
                }
                Object var11_12 = null;
                StoredIterator.close(i1);
                StoredIterator.close(i2);
                return bl3;
            }
            Object var11_13 = null;
            StoredIterator.close(i1);
            StoredIterator.close(i2);
            return bl2;
        }
        Object var11_14 = null;
        StoredIterator.close(i1);
        StoredIterator.close(i2);
        return bl;
    }

    Object makeIteratorData(StoredIterator iterator, DataCursor cursor) throws DbException, IOException {
        return cursor.getCurrentValue();
    }

    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    implements DataBinding {
        private static RecordNumberFormat format = new RecordNumberFormat();
        private int baseIndex;

        private IndexKeyBinding(int baseIndex) {
            this.baseIndex = baseIndex;
        }

        public DataFormat getDataFormat() {
            return format;
        }

        public Object dataToObject(DataBuffer data) throws IOException {
            return new Long(format.dataToRecordNumber(data) - (long)this.baseIndex);
        }

        public void objectToData(Object object, DataBuffer data) throws IOException {
            format.recordNumberToData(((Number)object).intValue() + this.baseIndex, data);
        }
    }
}

