/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredMapEntry;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView mapView) {
        super(mapView);
    }

    public boolean add(Object mapEntry) {
        Map.Entry entry = (Map.Entry)mapEntry;
        return this.add(entry.getKey(), entry.getValue());
    }

    public boolean remove(Object mapEntry) {
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)mapEntry;
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            int err = cursor.get(entry.getKey(), entry.getValue(), Db.DB_GET_BOTH, true);
            if (err == 0) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return err == 0;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean contains(Object mapEntry) {
        boolean bl;
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)mapEntry;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            int err = cursor.get(entry.getKey(), entry.getValue(), Db.DB_GET_BOTH, false);
            bl = err == 0;
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (buf.length() > 1) {
                    buf.append(',');
                }
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key != null) {
                    buf.append(key.toString());
                }
                buf.append('=');
                if (val == null) continue;
                buf.append(val.toString());
            }
            buf.append(']');
            string = buf.toString();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            StoredIterator.close(i);
            throw throwable;
        }
        StoredIterator.close(i);
        return string;
    }

    Object makeIteratorData(StoredIterator iterator, DataCursor cursor) throws DbException, IOException {
        return new StoredMapEntry(cursor.getCurrentKey(), cursor.getCurrentValue(), this, iterator);
    }

    boolean hasValues() {
        return true;
    }
}

