/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;

public abstract class StoredContainer
implements Cloneable {
    DataView view;

    StoredContainer(DataView view) {
        this.view = view;
    }

    public final boolean isWriteAllowed() {
        return this.view.isWriteAllowed();
    }

    public final boolean isDirtyReadAllowed() {
        return this.view.isDirtyReadAllowed();
    }

    public final boolean isDirtyReadEnabled() {
        return this.view.isDirtyReadEnabled();
    }

    public final boolean isAutoCommit() {
        return this.view.isAutoCommit();
    }

    public final boolean isTransactional() {
        return this.view.isTransactional();
    }

    final StoredContainer dirtyReadClone() {
        if (!this.isDirtyReadAllowed()) {
            return this;
        }
        try {
            StoredContainer cont = (StoredContainer)this.clone();
            cont.view = cont.view.dirtyReadView(true);
            return cont;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    final StoredContainer autoCommitClone() {
        if (!this.isTransactional()) {
            return this;
        }
        try {
            StoredContainer cont = (StoredContainer)this.clone();
            cont.view = cont.view.autoCommitView(true);
            return cont;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public final boolean areDuplicatesAllowed() {
        return this.view.areDuplicatesAllowed();
    }

    public final boolean areDuplicatesOrdered() {
        return this.view.areDuplicatesOrdered();
    }

    public final boolean areKeysRenumbered() {
        return this.view.areKeysRenumbered();
    }

    public final boolean isOrdered() {
        return this.view.isOrdered();
    }

    public final boolean isIndexed() {
        return this.view.getIndex() != null;
    }

    public int size() {
        throw new UnsupportedOperationException("collection size not available");
    }

    public boolean isEmpty() {
        try {
            return this.view.isEmpty();
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public void clear() {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            this.view.clear(null);
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    Object get(Object key) {
        try {
            Object[] ret = new Object[1];
            int err = this.view.get(key, null, Db.DB_SET, false, ret);
            return err == 0 ? ret[0] : null;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    Object put(Object key, Object value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] oldValue = new Object[1];
            this.view.put(key, value, 0, oldValue);
            this.commitAutoCommit(doAutoCommit);
            return oldValue[0];
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    final boolean removeKey(Object key, Object[] oldVal) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            boolean found = false;
            int err = cursor.get(key, null, Db.DB_SET, true);
            while (err == 0) {
                cursor.delete();
                found = true;
                if (oldVal != null && oldVal[0] == null) {
                    oldVal[0] = cursor.getCurrentValue();
                }
                err = cursor.get(null, null, Db.DB_NEXT_DUP, true);
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return found;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    boolean containsKey(Object key) {
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            int err = cursor.get(key, null, Db.DB_SET, false);
            boolean bl = err == 0;
            Object var6_6 = null;
            this.closeCursor(cursor);
            return bl;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    final boolean removeValue(Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            int err = cursor.find(value, true);
            if (err == 0) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return err == 0;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    boolean containsValue(Object value) {
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            int err = cursor.find(value, true);
            boolean bl = err == 0;
            Object var6_6 = null;
            this.closeCursor(cursor);
            return bl;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    final void closeCursor(DataCursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                throw StoredContainer.convertException(e);
            }
        }
    }

    final boolean beginAutoCommit() {
        if (this.isAutoCommit()) {
            try {
                CurrentTransaction currentTxn = this.view.getCurrentTxn();
                if (currentTxn.getTxn() == null) {
                    currentTxn.beginTxn();
                    return true;
                }
            }
            catch (DbException e) {
                throw new RuntimeExceptionWrapper(e);
            }
        }
        return false;
    }

    final void commitAutoCommit(boolean doAutoCommit) throws DbException {
        if (doAutoCommit) {
            this.view.getCurrentTxn().commitTxn();
        }
    }

    final RuntimeException handleException(Exception e, boolean doAutoCommit) {
        block2: {
            if (!doAutoCommit) break block2;
            try {
                this.view.getCurrentTxn().abortTxn();
            }
            catch (DbException ignored) {}
        }
        return StoredContainer.convertException(e);
    }

    static RuntimeException convertException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeExceptionWrapper(e);
    }
}

