/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.util.FastOutputStream;
import com.sleepycat.bdb.util.UtfOps;
import java.io.IOException;

public class TupleOutput
extends FastOutputStream {
    public TupleOutput() {
    }

    public TupleOutput(byte[] buffer) {
        super(buffer);
    }

    public final void writeBytes(String val) throws IOException {
        this.writeBytes(val.toCharArray());
    }

    public final void writeChars(String val) throws IOException {
        this.writeChars(val.toCharArray());
    }

    public final void writeString(String val) throws IOException {
        if (val != null) {
            this.writeString(val.toCharArray());
        }
        this.write(0);
    }

    public final void writeChar(int val) throws IOException {
        this.write((byte)(val >>> 8));
        this.write((byte)val);
    }

    public final void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    public final void writeByte(int val) throws IOException {
        byte b = (byte)val;
        b = b < 0 ? (byte)(b & 0x7F) : (byte)(b | 0xFFFFFF80);
        this.writeUnsignedByte(b);
    }

    public final void writeShort(int val) throws IOException {
        short s = (short)val;
        s = s < 0 ? (short)(s & Short.MAX_VALUE) : (short)(s | Short.MIN_VALUE);
        this.writeUnsignedShort(s);
    }

    public final void writeInt(int val) throws IOException {
        val = val < 0 ? (val &= Integer.MAX_VALUE) : (val |= Integer.MIN_VALUE);
        this.writeUnsignedInt(val);
    }

    public final void writeLong(long val) throws IOException {
        val = val < 0L ? (val &= Long.MAX_VALUE) : (val |= Long.MIN_VALUE);
        this.writeUnsignedLong(val);
    }

    public final void writeFloat(float val) throws IOException {
        this.writeUnsignedInt(Float.floatToIntBits(val));
    }

    public final void writeDouble(double val) throws IOException {
        this.writeUnsignedLong(Double.doubleToLongBits(val));
    }

    public final void writeBytes(char[] chars) throws IOException {
        int i = 0;
        while (i < chars.length) {
            this.write((byte)chars[i]);
            ++i;
        }
    }

    public final void writeChars(char[] chars) throws IOException {
        int i = 0;
        while (i < chars.length) {
            this.write((byte)(chars[i] >>> 8));
            this.write((byte)chars[i]);
            ++i;
        }
    }

    public final void writeString(char[] chars) throws IOException {
        if (chars.length == 0) {
            return;
        }
        int utfLength = UtfOps.getByteLength(chars);
        this.makeSpace(utfLength);
        UtfOps.charsToBytes(chars, 0, this.getBufferBytes(), this.getBufferLength(), chars.length);
        this.addSize(utfLength);
    }

    public final void writeUnsignedByte(int val) throws IOException {
        this.write(val);
    }

    public final void writeUnsignedShort(int val) throws IOException {
        this.write((byte)(val >>> 8));
        this.write((byte)val);
    }

    public final void writeUnsignedInt(long val) throws IOException {
        this.write((byte)(val >>> 24));
        this.write((byte)(val >>> 16));
        this.write((byte)(val >>> 8));
        this.write((byte)val);
    }

    private final void writeUnsignedLong(long val) throws IOException {
        this.write((byte)(val >>> 56));
        this.write((byte)(val >>> 48));
        this.write((byte)(val >>> 40));
        this.write((byte)(val >>> 32));
        this.write((byte)(val >>> 24));
        this.write((byte)(val >>> 16));
        this.write((byte)(val >>> 8));
        this.write((byte)val);
    }
}

