/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleSerialKeyExtractor
implements KeyExtractor {
    protected TupleFormat primaryKeyFormat;
    protected SerialFormat valueFormat;
    protected TupleFormat indexKeyFormat;

    public TupleSerialKeyExtractor(TupleFormat primaryKeyFormat, SerialFormat valueFormat, TupleFormat indexKeyFormat) {
        this.primaryKeyFormat = primaryKeyFormat;
        this.valueFormat = valueFormat;
        this.indexKeyFormat = indexKeyFormat;
    }

    public DataFormat getPrimaryKeyFormat() {
        return this.primaryKeyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public DataFormat getIndexKeyFormat() {
        return this.indexKeyFormat;
    }

    public void extractIndexKey(DataBuffer primaryKeyData, DataBuffer valueData, DataBuffer indexKeyData) throws IOException {
        TupleOutput output = this.indexKeyFormat.newOutput();
        TupleInput primaryKeyInput = this.primaryKeyFormat != null ? this.primaryKeyFormat.dataToInput(primaryKeyData) : null;
        Object valueInput = this.valueFormat != null ? this.valueFormat.dataToObject(valueData) : null;
        this.extractIndexKey(primaryKeyInput, valueInput, output);
        this.indexKeyFormat.outputToData(output, indexKeyData);
    }

    public void clearIndexKey(DataBuffer valueData) throws IOException {
        Object value = this.valueFormat.dataToObject(valueData);
        this.clearIndexKey(value);
        this.valueFormat.objectToData(value, valueData);
    }

    public abstract void extractIndexKey(TupleInput var1, Object var2, TupleOutput var3) throws IOException;

    public abstract void clearIndexKey(Object var1) throws IOException;
}

