/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class SerialOutput
extends ObjectOutputStream {
    private static final byte[] STREAM_HEADER;
    private ClassCatalog classCatalog;

    public SerialOutput(OutputStream out, ClassCatalog classCatalog) throws IOException {
        super(out);
        this.classCatalog = classCatalog;
        this.useProtocolVersion(2);
    }

    protected void writeClassDescriptor(ObjectStreamClass classdesc) throws IOException {
        try {
            byte[] id = this.classCatalog.getClassID(classdesc.getName());
            this.writeByte(id.length);
            this.write(id);
        }
        catch (IOException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    public static byte[] getStreamHeader() {
        return STREAM_HEADER;
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SerialOutput oos = new SerialOutput(baos, null);
        }
        catch (IOException e) {
            // empty catch block
        }
        STREAM_HEADER = baos.toByteArray();
    }
}

