/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.util.IOExceptionWrapper;
import com.sleepycat.bdb.util.UtfOps;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;

public class StoredClassCatalog
implements ClassCatalog {
    private static final byte REC_LAST_CLASS_ID = 0;
    private static final byte REC_CLASS_FORMAT = 1;
    private static final byte REC_CLASS_INFO = 2;
    private static final byte[] LAST_CLASS_ID_KEY = new byte[]{0};
    private DataEnvironment env;
    private DataDb db;
    private HashMap classMap;
    private HashMap formatMap;

    public StoredClassCatalog(DbEnv env, String file, String database, int openFlags) throws FileNotFoundException, DbException {
        this.env = DataEnvironment.getEnvironment(env);
        DbTxn txn = this.env.getTxn();
        if (txn != null) {
            openFlags &= ~Db.DB_AUTO_COMMIT;
        }
        Db db = new Db(env, 0);
        db.open(txn, file, database, 1, openFlags, 0);
        this.db = new DataDb(db);
        this.classMap = new HashMap();
        this.formatMap = new HashMap();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }
        catch (DbException e) {
            throw new IOExceptionWrapper(e);
        }
        this.db = null;
        this.formatMap = null;
        this.classMap = null;
    }

    public synchronized byte[] getClassID(String className) throws IOException, ClassNotFoundException {
        try {
            ClassInfo classInfo = this.getClassInfo(className);
            return classInfo.getClassID();
        }
        catch (DbException e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public synchronized ObjectStreamClass getClassFormat(String className) throws IOException, ClassNotFoundException {
        try {
            ClassInfo classInfo = this.getClassInfo(className);
            return classInfo.getClassFormat();
        }
        catch (DbException e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public ObjectStreamClass getClassFormat(byte[] classID) throws IOException, ClassNotFoundException {
        try {
            return this.getClassFormat(classID, this.newDbt());
        }
        catch (DbException e) {
            throw new IOExceptionWrapper(e);
        }
    }

    private synchronized ObjectStreamClass getClassFormat(byte[] classID, DataThang data) throws DbException, ClassNotFoundException, IOException {
        BigInteger classIDObj = new BigInteger(classID);
        ObjectStreamClass classFormat = (ObjectStreamClass)this.formatMap.get(classIDObj);
        if (classFormat == null) {
            byte[] keyBytes = new byte[classID.length + 1];
            keyBytes[0] = 1;
            System.arraycopy(classID, 0, keyBytes, 1, classID.length);
            DataThang key = this.newDbt();
            key.setBytes(keyBytes);
            int err = this.db.get(key, data, 0);
            if (err != 0) {
                throw new ClassNotFoundException("Catalog class ID not found");
            }
            ObjectInputStream ois = new ObjectInputStream(data.getByteStream());
            classFormat = (ObjectStreamClass)ois.readObject();
            this.formatMap.put(classIDObj, classFormat);
        }
        return classFormat;
    }

    private ClassInfo getClassInfo(String className) throws IOException, ClassNotFoundException, DbException, DbException {
        ClassInfo classInfo = (ClassInfo)this.classMap.get(className);
        if (classInfo != null) {
            return classInfo;
        }
        Class<?> cls = Class.forName(className);
        ObjectStreamClass classFormat = ObjectStreamClass.lookup(cls);
        char[] nameChars = className.toCharArray();
        byte[] keyBytes = new byte[1 + UtfOps.getByteLength(nameChars)];
        keyBytes[0] = 2;
        UtfOps.charsToBytes(nameChars, 0, keyBytes, 1, nameChars.length);
        DataThang key = this.newDbt();
        key.setBytes(keyBytes);
        DataThang data = this.newDbt();
        int err = this.db.get(key, data, 0);
        if (err != 0) {
            classInfo = this.putClassInfo(new ClassInfo(), className, key, classFormat);
        } else {
            classInfo = new ClassInfo(data);
            DataThang formatData = this.newDbt();
            ObjectStreamClass storedClassFormat = this.getClassFormat(classInfo.getClassID(), formatData);
            if (!StoredClassCatalog.areClassFormatsEqual(storedClassFormat, formatData.getBytes(), classFormat)) {
                classInfo = this.putClassInfo(classInfo, className, key, classFormat);
            }
            classInfo.setClassFormat(classFormat);
            this.classMap.put(className, classInfo);
        }
        return classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassInfo putClassInfo(ClassInfo classInfo, String className, DataThang classKey, ObjectStreamClass classFormat) throws DbException, ClassNotFoundException {
        byte[] idBytes;
        int putFlag;
        DataThang data;
        DataThang key;
        Dbc cursor;
        block6: {
            ClassInfo classInfo2;
            cursor = this.db.openCursor(true);
            try {
                key = this.newDbt();
                key.setBytes(LAST_CLASS_ID_KEY);
                data = this.newDbt();
                putFlag = Db.DB_CURRENT;
                int err = cursor.get(key, data, Db.DB_SET | this.env.getWriteLockFlag());
                if (err != 0) {
                    data.setBytes(new byte[1]);
                    putFlag = Db.DB_KEYLAST;
                }
                idBytes = data.getBytes();
                Object anotherClassInfo = this.classMap.get(className);
                if (anotherClassInfo == null) break block6;
                classInfo2 = (ClassInfo)anotherClassInfo;
                Object var18_13 = null;
            }
            catch (Throwable throwable) {
                Object var18_15 = null;
                this.db.closeCursor(cursor);
                throw throwable;
            }
            this.db.closeCursor(cursor);
            return classInfo2;
        }
        idBytes = StoredClassCatalog.incrementID(idBytes);
        data.setBytes(idBytes);
        cursor.put(key, data, putFlag);
        byte[] keyBytes = new byte[1 + idBytes.length];
        keyBytes[0] = 1;
        System.arraycopy(idBytes, 0, keyBytes, 1, idBytes.length);
        key.setBytes(keyBytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(classFormat);
        }
        catch (IOException e) {
            // empty catch block
        }
        data.setBytes(baos.toByteArray());
        this.db.put(key, data, 0);
        classInfo.setClassID(idBytes);
        classInfo.toDbt(data);
        this.db.put(classKey, data, 0);
        classInfo.setClassFormat(classFormat);
        this.classMap.put(className, classInfo);
        this.formatMap.put(new BigInteger(idBytes), classFormat);
        ClassInfo classInfo3 = classInfo;
        Object var18_14 = null;
        this.db.closeCursor(cursor);
        return classInfo3;
    }

    private static byte[] incrementID(byte[] key) {
        BigInteger id = new BigInteger(key);
        id = id.add(BigInteger.valueOf(1L));
        return id.toByteArray();
    }

    private static boolean areClassFormatsEqual(ObjectStreamClass format1, byte[] format1Bytes, ObjectStreamClass format2) {
        try {
            if (format1Bytes == null) {
                format1Bytes = StoredClassCatalog.getObjectBytes(format1);
            }
            byte[] format2Bytes = StoredClassCatalog.getObjectBytes(format2);
            return Arrays.equals(format2Bytes, format1Bytes);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static byte[] getObjectBytes(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private DataThang newDbt() {
        return new DataThang();
    }

    private static class ClassInfo
    implements Serializable {
        private byte[] classID;
        private transient ObjectStreamClass classFormat;

        ClassInfo() {
        }

        ClassInfo(DataThang dbt) {
            byte[] data = dbt.getDataBytes();
            byte len = data[0];
            this.classID = new byte[len];
            System.arraycopy(data, 1, this.classID, 0, len);
        }

        void toDbt(DataThang dbt) {
            byte[] data = new byte[1 + this.classID.length];
            data[0] = (byte)this.classID.length;
            System.arraycopy(this.classID, 0, data, 1, this.classID.length);
            dbt.setData(data, 0, data.length);
        }

        void setClassID(byte[] classID) {
            this.classID = classID;
        }

        byte[] getClassID() {
            return this.classID;
        }

        ObjectStreamClass getClassFormat() {
            return this.classFormat;
        }

        void setClassFormat(ObjectStreamClass classFormat) {
            this.classFormat = classFormat;
        }
    }
}

