/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;

final class KeyRange {
    private static final int EINVAL = 22;
    private DataThang beginKey;
    private DataThang endKey;
    private boolean isSingleKey;
    private boolean isCursorValid;

    public KeyRange() {
    }

    public KeyRange(DataThang singleKey) {
        this.beginKey = singleKey;
        this.isSingleKey = true;
    }

    public KeyRange(DataThang beginKey, boolean beginInclusive, DataThang endKey, boolean endInclusive) {
        if (beginKey != null) {
            this.beginKey = beginKey;
            if (!beginInclusive) {
                this.beginKey.increment();
            }
        }
        if (endKey != null) {
            this.endKey = endKey;
            if (endInclusive) {
                this.endKey.increment();
            }
        }
    }

    public KeyRange(KeyRange other) {
        this.beginKey = other.beginKey;
        this.endKey = other.endKey;
        this.isSingleKey = other.isSingleKey;
    }

    public KeyRange subRange(DataThang singleKey) throws KeyRangeException {
        if (!this.check(singleKey)) {
            throw new KeyRangeException("singleKey out of range");
        }
        return new KeyRange(singleKey);
    }

    public KeyRange subRange(DataThang beginKey, boolean beginInclusive, DataThang endKey, boolean endInclusive) throws KeyRangeException {
        KeyRange range = new KeyRange(beginKey, beginInclusive, endKey, endInclusive);
        if (range.beginKey == null) {
            range.beginKey = this.beginKey;
        } else if (!this.check(range.beginKey)) {
            throw new KeyRangeException("beginKey out of range");
        }
        if (range.endKey == null) {
            range.endKey = this.endKey;
        } else if (!this.checkRangeEnd(range.endKey)) {
            throw new KeyRangeException("endKey out of range");
        }
        return range;
    }

    public final DataThang getSingleKey() {
        return this.isSingleKey ? this.beginKey : null;
    }

    final boolean hasBound() {
        return this.isSingleKey || this.endKey != null || this.beginKey != null;
    }

    public String toString() {
        return "[KeyRange " + this.beginKey + ' ' + this.endKey + (this.isSingleKey ? " single" : "");
    }

    public boolean check(DataThang key) {
        if (this.isSingleKey) {
            return key.compareTo(this.beginKey) == 0;
        }
        if (this.beginKey != null && key.compareTo(this.beginKey) < 0) {
            return false;
        }
        return this.endKey == null || key.compareTo(this.endKey) < 0;
    }

    private boolean checkRangeEnd(DataThang key) {
        if (this.isSingleKey) {
            return key.compareTo(this.beginKey) == 0;
        }
        if (this.beginKey != null && key.compareTo(this.beginKey) < 0) {
            return false;
        }
        return this.endKey == null || key.compareTo(this.endKey) <= 0;
    }

    public int get(DataDb db, Dbc cursor, DataThang key, DataThang data, int flags) throws DbException {
        boolean wasInvalid;
        int pos;
        if (this.beginKey == null && this.endKey == null) {
            return db.get(cursor, key, data, flags);
        }
        int extraFlags = flags & 0xFFFFFF00;
        int origPos = pos = flags & 0xFF;
        int err = 0;
        boolean bl = wasInvalid = !this.isCursorValid;
        if (pos == Db.DB_CURRENT || pos == Db.DB_NEXT_DUP) {
            if (wasInvalid) {
                this.throwInvalid(key, data);
            }
            err = db.get(cursor, key, data, pos | extraFlags);
        } else if (pos == Db.DB_SET || pos == Db.DB_SET_RANGE || pos == Db.DB_SET_RECNO || pos == Db.DB_GET_BOTH) {
            if (pos != Db.DB_SET_RANGE && !this.check(key)) {
                err = this.setInvalid(key, data);
            } else {
                err = db.get(cursor, key, data, pos | extraFlags);
                if (err == 0 && pos == Db.DB_SET_RANGE && !this.check(key)) {
                    err = this.setInvalid(key, data);
                }
            }
        } else if (pos == Db.DB_FIRST || pos == Db.DB_NEXT || pos == Db.DB_NEXT_NODUP) {
            if (wasInvalid) {
                pos = Db.DB_FIRST;
            }
            if (this.isSingleKey) {
                if (pos == Db.DB_NEXT_NODUP) {
                    err = -30990;
                } else if (pos == Db.DB_FIRST) {
                    key.copy(this.beginKey);
                    err = db.get(cursor, key, data, Db.DB_SET | extraFlags);
                } else {
                    err = db.get(cursor, key, data, Db.DB_NEXT_DUP | extraFlags);
                }
            } else {
                if (this.beginKey == null) {
                    err = db.get(cursor, key, data, pos | extraFlags);
                } else if (pos == Db.DB_FIRST) {
                    key.copy(this.beginKey);
                    err = db.get(cursor, key, data, Db.DB_SET_RANGE | extraFlags);
                } else {
                    err = db.get(cursor, key, data, pos | extraFlags);
                }
                if (err == 0 && !this.check(key)) {
                    if (pos == Db.DB_FIRST) {
                        err = this.setInvalid(key, data);
                    } else {
                        err = db.get(cursor, key, data, pos == Db.DB_NEXT_NODUP ? Db.DB_PREV_NODUP : Db.DB_PREV);
                        if (err != 0) {
                            throw new DbException("Range internal error", err);
                        }
                        err = -30990;
                    }
                }
            }
        } else if (pos == Db.DB_LAST || pos == Db.DB_PREV || pos == Db.DB_PREV_NODUP) {
            if (wasInvalid) {
                pos = Db.DB_LAST;
            }
            if (this.isSingleKey) {
                if (pos == Db.DB_PREV_NODUP) {
                    err = -30990;
                } else if (this.endKey == null) {
                    this.endKey = new DataThang(this.beginKey);
                    this.endKey.increment();
                }
            }
            if (err == 0) {
                if (this.endKey == null) {
                    err = db.get(cursor, key, data, pos | extraFlags);
                } else if (pos == Db.DB_LAST) {
                    key.copy(this.endKey);
                    err = db.get(cursor, key, data, Db.DB_SET_RANGE | extraFlags);
                    err = err == 0 ? db.get(cursor, key, data, (origPos == Db.DB_PREV_NODUP ? Db.DB_PREV_NODUP : Db.DB_PREV) | extraFlags) : db.get(cursor, key, data, Db.DB_LAST | extraFlags);
                } else {
                    err = db.get(cursor, key, data, pos | extraFlags);
                }
            }
            if (err == 0 && this.beginKey != null) {
                int compare = key.compareTo(this.beginKey);
                if (this.isSingleKey ? compare != 0 : compare < 0) {
                    if (pos == Db.DB_LAST) {
                        err = this.setInvalid(key, data);
                    } else {
                        err = db.get(cursor, key, data, pos == Db.DB_PREV_NODUP ? Db.DB_NEXT_NODUP : Db.DB_NEXT);
                        if (err != 0) {
                            throw new DbException("Range internal error", err);
                        }
                        err = -30990;
                    }
                }
            }
        } else if (pos == Db.DB_CONSUME) {
            err = db.get(cursor, key, data, flags);
        } else {
            throw new DbException("Unsupported flag", 22);
        }
        if (err == 0) {
            this.isCursorValid = true;
        }
        return err;
    }

    private void throwInvalid(DataThang key, DataThang data) throws DbException {
        this.setInvalid(key, data);
        throw new DbException("Cursor not initialized", 22);
    }

    private int setInvalid(DataThang key, DataThang data) {
        this.isCursorValid = false;
        if (key != null) {
            key.set_size(0);
        }
        if (data != null) {
            data.set_size(0);
        }
        return -30990;
    }
}

