/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.db.Db;
import com.sleepycat.db.Dbt;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;

public final class DataThang
extends Dbt
implements DataBuffer {
    private static DataThang discardDataThang;
    private Object formation;

    static DataThang getDiscardDataThang() {
        if (discardDataThang == null) {
            discardDataThang = new DataThang();
            discardDataThang.setFlags(Db.DB_DBT_USERMEM | Db.DB_DBT_PARTIAL);
            discardDataThang.set_data(new byte[0]);
        }
        return discardDataThang;
    }

    public DataThang() {
        this.setFlags(Db.DB_DBT_MALLOC);
    }

    public DataThang(byte[] bytes) {
        this();
        this.setBytes(bytes);
    }

    public DataThang(DataThang copyFrom) {
        this();
        this.copy(copyFrom);
    }

    public void copy(DataThang copyFrom) {
        this.setBytes(copyFrom.getBytes());
    }

    public void setBytes(byte[] bytes) {
        this.formation = null;
        this.set_data(bytes);
        this.set_offset(0);
        this.set_size(bytes != null ? bytes.length : 0);
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.formation = null;
        this.set_data(bytes);
        this.set_offset(offset);
        this.set_size(length);
    }

    public byte[] getBytes() {
        byte[] bytes = this.get_data();
        if (bytes == null) {
            return null;
        }
        int size = this.get_size();
        byte[] data = new byte[size];
        System.arraycopy(bytes, this.get_offset(), data, 0, size);
        return data;
    }

    public ByteArrayInputStream getByteStream() {
        return new ByteArrayInputStream(this.get_data(), this.get_offset(), this.get_size());
    }

    public void increment() {
        this.formation = null;
        byte[] data = this.get_data();
        int offset = this.get_offset();
        int size = this.get_size();
        byte[] newData = new byte[size + 1];
        System.arraycopy(data, offset, newData, 0, size);
        int i = offset + size - 1;
        while (i >= offset) {
            int val = 0xFF & data[i];
            if (val != 255) {
                newData[i] = (byte)(val + 1);
                this.setBytes(newData, 0, size);
                return;
            }
            --i;
        }
        this.setBytes(newData);
    }

    public int compareTo(Dbt key2) {
        byte[] d1 = this.get_data();
        int o1 = this.get_offset();
        int s1 = this.get_size();
        byte[] d2 = key2.get_data();
        int o2 = key2.get_offset();
        int s2 = key2.get_size();
        int i = 0;
        while (i < s1 && i < s2) {
            int b1 = 0xFF & d1[o1 + i];
            int b2 = 0xFF & d2[o2 + i];
            if (b1 < b2) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            ++i;
        }
        if (s1 < s2) {
            return -1;
        }
        if (s1 > s2) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Dbt other) {
        return this.compareTo(other) == 0;
    }

    public void dump(PrintStream out) {
        DataThang.dump(this, out);
    }

    public static void dump(Dbt dbt, PrintStream out) {
        out.print(' ');
        out.print(DataThang.toString(dbt));
        out.println();
    }

    public static String toString(Dbt dbt) {
        int len = dbt.get_offset() + dbt.get_size();
        StringBuffer buf = new StringBuffer(len * 2);
        byte[] data = dbt.get_data();
        int i = dbt.get_offset();
        while (i < len) {
            String num = Integer.toHexString(data[i]);
            if (num.length() < 2) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(data[i]));
            ++i;
        }
        if (dbt.get_size() == 4) {
            buf.append(" (recno ");
            buf.append(dbt.get_recno_key_data());
            buf.append(')');
        }
        return buf.toString();
    }

    public String toString() {
        return DataThang.toString(this);
    }

    public void setData(byte[] data, int offset, int length) {
        this.formation = null;
        this.set_data(data);
        this.set_offset(offset);
        this.set_size(length);
    }

    public byte[] getDataBytes() {
        return this.get_data();
    }

    public int getDataOffset() {
        return this.get_offset();
    }

    public int getDataLength() {
        return this.get_size();
    }

    public void setDataFormation(Object formation) {
        this.formation = formation;
    }

    public Object getDataFormation() {
        return this.formation;
    }

    public void clearDataFormation() {
        this.formation = null;
    }
}

