/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.ForeignKeyIndex;
import com.sleepycat.bdb.PrimaryKeyAssigner;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class DataStore {
    DataDb db;
    DataFormat keyFormat;
    DataFormat valueFormat;
    PrimaryKeyAssigner keyAssigner;
    ArrayList indices;
    ArrayList inverseIndices;

    public DataStore(Db db, DataFormat keyFormat, DataFormat valueFormat, PrimaryKeyAssigner keyAssigner) {
        this.db = new DataDb(db);
        this.keyFormat = keyFormat;
        this.valueFormat = valueFormat;
        this.keyAssigner = keyAssigner;
        if (keyFormat instanceof RecordNumberFormat && !this.db.hasRecNumAccess()) {
            throw new IllegalArgumentException(this.db.toString() + " RecordNumberFormat is only allowed when the" + " access method has record number keys");
        }
        if (valueFormat instanceof RecordNumberFormat) {
            throw new IllegalArgumentException(this.db.toString() + " RecordNumberFormat is only allowed for keys");
        }
    }

    public void close() throws DbException {
        this.db.close();
        if (this.indices != null) {
            int i = 0;
            while (i < this.indices.size()) {
                DataIndex index = (DataIndex)this.indices.get(i);
                index.db.close();
                ++i;
            }
        }
    }

    public final DbEnv getEnv() {
        return this.db.env.getEnv();
    }

    public final DataFormat getKeyFormat() {
        return this.keyFormat;
    }

    public final PrimaryKeyAssigner getKeyAssigner() {
        return this.keyAssigner;
    }

    public final DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public final Iterator getIndices() {
        return this.indices != null ? this.indices.iterator() : null;
    }

    public String toString() {
        return this.db.toString();
    }

    final void addIndex(DataIndex index) {
        if (this.db.areDuplicatesAllowed()) {
            throw new IllegalArgumentException("The primary store of an index must now allow duplicates");
        }
        if (this.indices == null) {
            this.indices = new ArrayList();
        }
        this.indices.add(index);
    }

    final void addInverseIndex(ForeignKeyIndex inverseIndex) {
        if (this.inverseIndices == null) {
            this.inverseIndices = new ArrayList();
        }
        this.inverseIndices.add(inverseIndex);
    }

    void applyChange(DataThang keyThang, DataThang oldValueThang, DataThang newValueThang) throws DbException, IOException {
        DataIndex index;
        int i;
        if (newValueThang == null && this.inverseIndices != null) {
            i = 0;
            while (i < this.inverseIndices.size()) {
                index = (ForeignKeyIndex)this.inverseIndices.get(i);
                ((ForeignKeyIndex)index).applyForeignDelete(keyThang);
                ++i;
            }
        }
        if (this.indices != null) {
            i = 0;
            while (i < this.indices.size()) {
                index = (DataIndex)this.indices.get(i);
                index.applyChange(keyThang, oldValueThang, newValueThang);
                ++i;
            }
        }
    }
}

