/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.IntegrityConstraintException;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import java.io.IOException;

public class DataIndex {
    DataDb db;
    DataStore store;
    DataFormat keyFormat;
    KeyExtractor keyExtractor;

    public DataIndex(DataStore store, Db db, DataFormat keyFormat, KeyExtractor keyExtractor) {
        this.store = store;
        this.keyFormat = keyFormat;
        this.keyExtractor = keyExtractor;
        this.db = new DataDb(db);
        if (store.db.isTransactional() != this.db.isTransactional()) {
            throw new IllegalArgumentException(this.db + " and " + store.db + " must must both be transactional or non-transactional");
        }
        if (this.db.areDuplicatesAllowed() && !this.db.areDuplicatesOrdered()) {
            throw new IllegalArgumentException(this.db + " must use sorted duplicates for index");
        }
        if (!keyFormat.equals(keyExtractor.getIndexKeyFormat())) {
            throw new IllegalArgumentException(this.db + " extractor index key format mismatch");
        }
        if (keyExtractor.getPrimaryKeyFormat() != null && !store.keyFormat.equals(keyExtractor.getPrimaryKeyFormat())) {
            throw new IllegalArgumentException(this.db + " extractor primary key format mismatch");
        }
        if (keyExtractor.getValueFormat() != null && !store.valueFormat.equals(keyExtractor.getValueFormat())) {
            throw new IllegalArgumentException(this.db + " extractor value format mismatch");
        }
        if (keyFormat instanceof RecordNumberFormat && !this.db.hasRecNumAccess()) {
            throw new IllegalArgumentException(this.db + " RecordNumberFormat is only allowed when the" + " access method has record number keys");
        }
        store.addIndex(this);
    }

    public final DataStore getStore() {
        return this.store;
    }

    public final DataFormat getKeyFormat() {
        return this.keyFormat;
    }

    public final KeyExtractor getKeyExtractor() {
        return this.keyExtractor;
    }

    public String toString() {
        return this.db.toString();
    }

    void applyChange(DataThang keyThang, DataThang oldValueThang, DataThang newValueThang) throws DbException, IOException {
        DataThang oldIndexKey = null;
        if (oldValueThang != null) {
            oldIndexKey = new DataThang();
            this.keyExtractor.extractIndexKey(this.keyExtractor.getPrimaryKeyFormat() != null ? keyThang : null, this.keyExtractor.getValueFormat() != null ? oldValueThang : null, oldIndexKey);
            if (oldIndexKey.getDataLength() == 0) {
                oldIndexKey = null;
            }
        }
        DataThang newIndexKey = null;
        if (newValueThang != null) {
            newIndexKey = new DataThang();
            this.keyExtractor.extractIndexKey(this.keyExtractor.getPrimaryKeyFormat() != null ? keyThang : null, this.keyExtractor.getValueFormat() != null ? newValueThang : null, newIndexKey);
            if (newIndexKey.getDataLength() == 0) {
                newIndexKey = null;
            }
        }
        if (oldIndexKey == null && newIndexKey == null) {
            return;
        }
        if (oldIndexKey != null && newIndexKey != null && oldIndexKey.compareTo(newIndexKey) == 0) {
            return;
        }
        if (oldIndexKey != null) {
            this.applyIndexDelete(keyThang, oldIndexKey);
        }
        if (newIndexKey != null) {
            this.applyIndexInsert(keyThang, newIndexKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyIndexDelete(DataThang keyThang, DataThang oldIndexKey) throws DbException, IOException {
        Dbc cursor = this.db.openCursor(true);
        try {
            int err = cursor.get(oldIndexKey, keyThang, Db.DB_GET_BOTH | this.store.db.env.getWriteLockFlag());
            if (err != 0) {
                throw new IntegrityConstraintException("Index entry not found");
            }
            cursor.delete(0);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.db.closeCursor(cursor);
            throw throwable;
        }
        this.db.closeCursor(cursor);
    }

    void applyIndexInsert(DataThang keyThang, DataThang newIndexKey) throws DbException, IOException {
        int err = this.db.put(newIndexKey, keyThang, Db.DB_NODUPDATA);
        if (err != 0) {
            throw new IntegrityConstraintException("Index entry already exists");
        }
    }
}

