/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.KeyRange;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import java.io.IOException;

public final class DataCursor {
    private Dbc cursor;
    private DbTxn txn;
    private DataView view;
    private DataEnvironment env;
    private DataDb db;
    private KeyRange range;
    private boolean writeAllowed;
    private boolean dirtyRead;
    private DataThang keyThang;
    private DataThang valueThang;
    private DataThang primaryKeyThang;
    private DataThang otherThang;
    private int cursorDbType;
    private DataCursor[] indexCursorsToClose;
    private boolean closeDirect;
    private boolean isJoinCursor;

    public DataCursor(DataView view, boolean writeAllowed) throws DbException, IOException {
        this.init(view, writeAllowed, null, null);
    }

    public DataCursor(DataView view, boolean writeAllowed, Object singleKey) throws DbException, IOException {
        this.init(view, writeAllowed, view.subRange(singleKey), null);
    }

    public DataCursor(DataView view, boolean writeAllowed, Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive) throws DbException, IOException {
        this.init(view, writeAllowed, view.subRange(beginKey, beginInclusive, endKey, endInclusive), null);
    }

    public DataCursor(DataCursor other) throws DbException, IOException {
        this.view = other.view;
        this.env = other.env;
        this.db = other.db;
        this.writeAllowed = other.writeAllowed;
        this.dirtyRead = other.dirtyRead;
        this.initThangs();
        this.keyThang.copy(other.keyThang);
        this.valueThang.copy(other.valueThang);
        if (this.primaryKeyThang != this.keyThang) {
            this.primaryKeyThang.copy(other.primaryKeyThang);
        }
        this.range = other.range;
        this.cursor = this.db.dupCursor(other.cursor, this.writeAllowed, Db.DB_POSITION);
        this.txn = other.txn;
        this.closeDirect = false;
    }

    DataCursor(DataView view, DataCursor[] indexCursors, boolean presorted, boolean closeIndexCursors) throws DbException, IOException {
        this.isJoinCursor = true;
        if (view.index != null) {
            throw new IllegalArgumentException("Primary view in join must not be indexed");
        }
        Dbc[] cursors = new Dbc[indexCursors.length];
        int i = 0;
        while (i < cursors.length) {
            DataIndex index = indexCursors[i].view.index;
            if (index == null || index.store != view.store) {
                throw new IllegalArgumentException("Join cursor for view " + index + " is not indexed on primary store " + view.store);
            }
            cursors[i] = indexCursors[i].cursor;
            ++i;
        }
        Dbc joinCursor = view.store.db.db.join(cursors, presorted ? Db.DB_JOIN_NOSORT : 0);
        this.init(view, false, null, joinCursor);
        if (closeIndexCursors) {
            this.indexCursorsToClose = indexCursors;
        }
    }

    private void init(DataView view, boolean writeAllowed, KeyRange range, Dbc cursor) throws DbException, IOException {
        this.view = view;
        this.env = view.store.db.env;
        this.range = range != null ? range : new KeyRange(view.range);
        this.writeAllowed = writeAllowed && view.isWriteAllowed();
        this.dirtyRead = view.dirtyRead;
        this.initThangs();
        this.db = view.index != null ? view.index.db : view.store.db;
        this.cursorDbType = this.db.db.getDbType();
        if (cursor != null) {
            this.cursor = cursor;
            this.closeDirect = true;
        } else {
            this.cursor = this.db.openCursor(this.writeAllowed);
            this.closeDirect = false;
        }
    }

    private void initThangs() throws DbException, IOException {
        this.keyThang = new DataThang();
        this.primaryKeyThang = this.view.index != null ? new DataThang() : this.keyThang;
        this.valueThang = new DataThang();
    }

    public void close() throws DbException, IOException {
        DataCursor[] toClose;
        if (this.cursor != null) {
            toClose = this.cursor;
            this.cursor = null;
            if (this.closeDirect) {
                toClose.close();
            } else {
                this.db.closeCursor((Dbc)toClose);
            }
        }
        if (this.indexCursorsToClose != null) {
            toClose = this.indexCursorsToClose;
            this.indexCursorsToClose = null;
            int i = 0;
            while (i < toClose.length) {
                toClose[i].close();
                ++i;
            }
        }
    }

    public DataView getView() {
        return this.view;
    }

    KeyRange getRange() {
        return this.range;
    }

    public boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    public Object getCurrentKey() throws DbException, IOException {
        if (this.view.keyBinding == null) {
            throw new UnsupportedOperationException("getCurrentKey requires keyBinding");
        }
        return this.view.makeKey(this.keyThang);
    }

    public Object getCurrentValue() throws DbException, IOException {
        return this.view.makeValue(this.primaryKeyThang, this.valueThang);
    }

    public boolean hasRecNumAccess() {
        return this.db.hasRecNumAccess();
    }

    public int getCurrentRecordNumber() throws DbException, IOException {
        if (this.cursorDbType == 1) {
            if (this.otherThang == null) {
                this.otherThang = new DataThang();
            }
            DataThang discardThang = DataThang.getDiscardDataThang();
            this.cursor.get(discardThang, this.otherThang, Db.DB_GET_RECNO);
            return this.otherThang.get_recno_key_data();
        }
        return this.keyThang.get_recno_key_data();
    }

    public int get(Object key, Object value, int flag, boolean lockForWrite) throws DbException, IOException {
        int err = 0;
        if (this.view.btreeRecNumAccess && flag == Db.DB_SET) {
            flag = Db.DB_SET_RECNO;
        }
        int indexCursorFlag = flag;
        int indexPrimaryFlag = 0;
        if (flag == Db.DB_GET_BOTH) {
            this.view.useValue(value, this.valueThang, null);
            err = this.view.useKey(key, value, this.keyThang, this.range);
            indexCursorFlag = Db.DB_SET;
            indexPrimaryFlag = flag;
        } else if (flag == Db.DB_SET || flag == Db.DB_SET_RANGE || flag == Db.DB_SET_RECNO) {
            err = this.view.useKey(key, value, this.keyThang, this.range);
        } else {
            if (flag == Db.DB_GET_RECNO || flag == Db.DB_JOIN_ITEM) {
                throw new IllegalArgumentException("flag not supported: " + flag);
            }
            if (key != null || value != null) {
                throw new IllegalArgumentException("key and value must be null");
            }
        }
        if (err == 0) {
            err = this.lowLevelGet(flag, indexCursorFlag, indexPrimaryFlag, lockForWrite);
        }
        return err;
    }

    public int find(Object value, boolean findFirst) throws DbException, IOException {
        int err;
        if (this.isJoinCursor) {
            throw new UnsupportedOperationException();
        }
        this.view.useValue(value, this.valueThang, null);
        if (this.view.entityBinding != null && this.view.index == null && (findFirst || !this.view.areDuplicatesAllowed())) {
            err = this.view.useKey(null, value, this.keyThang, this.range);
            if (err == 0) {
                err = this.lowLevelGet(Db.DB_GET_BOTH, Db.DB_SET, Db.DB_GET_BOTH, false);
            }
        } else {
            if (this.otherThang == null) {
                this.otherThang = new DataThang();
            }
            this.otherThang.copy(this.valueThang);
            int flag = findFirst ? Db.DB_FIRST : Db.DB_LAST;
            err = 0;
            while (err == 0) {
                err = this.get(null, null, flag, false);
                if (err == 0 && this.valueThang.compareTo(this.otherThang) == 0) break;
                int n = flag = findFirst ? Db.DB_NEXT : Db.DB_PREV;
            }
        }
        return err;
    }

    public int count() throws DbException, IOException {
        if (this.isJoinCursor) {
            throw new UnsupportedOperationException();
        }
        return this.cursor.count(0);
    }

    public int put(Object key, Object value, int flag, Object[] oldValue) throws DbException, IOException {
        return this.put(key, value, flag, oldValue, false);
    }

    public int put(Object key, Object value, int flag, Object[] oldValue, boolean useCurrentKey) throws DbException, IOException {
        DataThang oldValueThang;
        if (this.isJoinCursor) {
            throw new UnsupportedOperationException();
        }
        if (this.view.index != null) {
            throw new UnsupportedOperationException("put with index not allowed");
        }
        boolean doUpdate = false;
        int err = 0;
        if (flag == Db.DB_CURRENT) {
            doUpdate = true;
        } else if (flag != Db.DB_AFTER && flag != Db.DB_BEFORE) {
            if (!useCurrentKey && (err = this.view.useKey(key, value, this.keyThang, this.range)) != 0) {
                throw new IllegalArgumentException("key out of range");
            }
            if (flag == 0) {
                int n = flag = this.view.areDuplicatesOrdered() ? Db.DB_NODUPDATA : Db.DB_KEYFIRST;
            }
            if (flag == Db.DB_KEYFIRST || flag == Db.DB_KEYLAST) {
                if (!this.view.areDuplicatesAllowed() && (err = this.lowLevelGet(Db.DB_SET, 0, 0, true)) == 0) {
                    doUpdate = true;
                }
            } else if (flag != Db.DB_NODUPDATA) {
                throw new IllegalArgumentException("flag unknown: " + flag);
            }
        }
        if (doUpdate) {
            if (oldValue != null) {
                oldValue[0] = this.getCurrentValue();
            }
            if (this.otherThang == null) {
                this.otherThang = new DataThang();
            }
            this.otherThang.copy(this.valueThang);
            oldValueThang = this.otherThang;
        } else {
            if (oldValue != null) {
                oldValue[0] = null;
            }
            oldValueThang = null;
        }
        DataThang checkKeyThang = flag == Db.DB_AFTER ? null : this.keyThang;
        this.view.useValue(value, this.valueThang, checkKeyThang);
        err = this.db.put(this.cursor, this.keyThang, this.valueThang, flag);
        if (err == 0) {
            this.view.store.applyChange(this.primaryKeyThang, oldValueThang, this.valueThang);
        }
        return err;
    }

    public int delete() throws DbException, IOException {
        if (this.isJoinCursor || !this.writeAllowed) {
            throw new UnsupportedOperationException();
        }
        int err = this.view.index != null ? this.view.store.db.delete(this.primaryKeyThang, 0) : this.cursor.delete(0);
        if (err == 0) {
            this.view.store.applyChange(this.primaryKeyThang, this.valueThang, null);
        }
        return err;
    }

    private int lowLevelGet(int flag, int indexCursorFlag, int indexPrimaryFlag, boolean lockForWrite) throws DbException {
        int err;
        int otherFlags = 0;
        if (this.dirtyRead) {
            otherFlags |= Db.DB_DIRTY_READ;
        }
        if (lockForWrite && !this.dirtyRead && !this.env.isDirtyRead()) {
            otherFlags |= this.env.getWriteLockFlag();
        }
        this.keyThang.clearDataFormation();
        this.primaryKeyThang.clearDataFormation();
        this.valueThang.clearDataFormation();
        if (this.view.index != null) {
            if (this.isJoinCursor) {
                throw new UnsupportedOperationException();
            }
            if (this.view.btreeRecNumAccess && indexCursorFlag == Db.DB_SET) {
                indexCursorFlag = Db.DB_SET_RECNO;
            }
            if ((err = this.range.get(this.db, this.cursor, this.keyThang, this.primaryKeyThang, indexCursorFlag | otherFlags)) == 0) {
                err = this.view.store.db.get(this.primaryKeyThang, this.valueThang, indexPrimaryFlag | otherFlags);
            }
        } else {
            if (this.isJoinCursor) {
                if (flag != Db.DB_FIRST && flag != Db.DB_NEXT && flag != Db.DB_NEXT_NODUP) {
                    throw new UnsupportedOperationException();
                }
                flag = 0;
                otherFlags = 0;
            }
            if (this.view.btreeRecNumAccess && flag == Db.DB_SET) {
                flag = Db.DB_SET_RECNO;
            }
            err = this.range.get(this.db, this.cursor, this.keyThang, this.valueThang, flag | otherFlags);
        }
        return err;
    }
}

