# REGISTRY.TCL - Setup procedures for implementing tornado registry wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01e,31mar99,bjl  set infVals(torRegManual) for manual registry.  
# 01d,24mar99,bjl  turn off inf write to registry after queueExecute.
# 01c,10feb99,tcy  modified for backward compatibility pages
# 01b,26jan99,tcy  added missing procedure regOptionRegValueRead().
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(torRegistry) - display options to run tornado registry
#
# This procedure will display options to run tornado registry. Options are:
# torRegStartup - runs tornado registry when user logs on
# torRegRemote  - uses a remote server to run tornado registry
# torRegManual  - runs tornado registry manually (nothing is done by Setup)
# torRegNTServ  - runs tornado registry as a service
#
# SYNOPSIS
# .tS
# pageCreate(torRegistry)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(torRegistry) {} {
    global ctrlVals
    global setupVals

    set msg0 [strTableGet 1570_OPTION_SELECT]
    set msgRegDesc [strTableGet 1191_REGISTRY_DESC]

    set ctrlVals(torRegStartup) [strTableGet 1577_OPTION_STARTUP]
    set ctrlVals(torRegRemote) [strTableGet 1579_OPTION_REMOTE]
    set ctrlVals(torRegManual) [strTableGet 1576_OPTION_MANUAL]
    set ctrlVals(torRegNTServ) [strTableGet 1578_OPTION_SERVICE]

    set msg0Ctrl [list label -name msg0 -title $msg0 \
                             -x 100 -y 40 -w 205 -h 20]

    set msgRegDescCtrl [list label -name msg0 \
                         -title $msgRegDesc \
                         -x 100 -y 10 -w 205 -h 24]
    set radio1_ypos 65
    set radio2_ypos 78
    set radio3_ypos 91
    set radio4_ypos 104

    set torRegStartupCtrl [list choice \
                -name torRegStartup \
                -title $ctrlVals(torRegStartup) \
                -callback {onTorRegOptSel torRegStartup}\
                -newgroup -auto \
                -x 100 -y $radio1_ypos -w 205 -h 10]

    if {$ctrlVals(NT)} {
        set torRegNTServCtrl [list choice \
                    -name torRegNTServ \
                    -title $ctrlVals(torRegNTServ) \
                    -auto \
                    -callback {onTorRegOptSel torRegNTServ} \
                    -x 100 -y $radio2_ypos -w 205 -h 10]
    }

    if {$ctrlVals(NT)} {
        set torRegManualCtrl [list choice \
                    -name torRegManual \
                    -title $ctrlVals(torRegManual) \
                    -auto \
                    -callback {onTorRegOptSel torRegManual}\
                    -x 100 -y $radio3_ypos -w 205 -h 10]
    } else {
        set torRegManualCtrl [list choice \
                    -name torRegManual \
                    -title $ctrlVals(torRegManual) \
                    -auto \
                    -callback {onTorRegOptSel torRegManual}\
                    -x 100 -y $radio2_ypos -w 205 -h 10]

    }

    if {$ctrlVals(NT)} {
        set torRegRemoteCtrl [list choice \
                    -name torRegRemote \
                    -title $ctrlVals(torRegRemote) \
                    -auto \
                    -callback {onTorRegOptSel torRegRemote}\
                    -x 100 -y $radio4_ypos -w 205 -h 10]
    } else {
        set torRegRemoteCtrl [list choice \
                    -name torRegRemote \
                    -title $ctrlVals(torRegRemote) \
                    -auto \
                    -callback {onTorRegOptSel torRegRemote}\
                    -x 100 -y $radio3_ypos -w 205 -h 10]
    }
    if {$ctrlVals(NT)} {
        set msg1Ctrl [list label -name msg1 \
                                 -title [strTableGet 1580_OPTION_DESC] \
                                 -x 100 -y 125 -w 205 -h 55]

        set ctrlVals(volatileFrm) [list $msg0Ctrl $msgRegDescCtrl \
                                        $torRegStartupCtrl $torRegNTServCtrl \
                                        $torRegManualCtrl $torRegRemoteCtrl \
                                        $msg1Ctrl \
        ]
    } else {
        set msg1Ctrl [list label -name msg1 \
                                 -title [strTableGet 1581_OPTION_DESC] \
                                 -x 100 -y 125 -w 205 -h 30]

        set ctrlVals(volatileFrm) [list $msg0Ctrl $msgRegDescCtrl \
                                        $torRegStartupCtrl $torRegManualCtrl \
                                        $torRegRemoteCtrl \
                                        $msg1Ctrl \
        ]
    }

    set w [dlgFrmCreate [strTableGet 1490_TITLE_REGISTRY_HOST]]

    # if user does not have admin privileges, do not allow
    # installation of Registry as a service.

    if {$ctrlVals(NT)} {
        if {!$ctrlVals(admin)} {
            controlEnable $w.torRegNTServ 0
        }
    }

    # test automation

    if { $ctrlVals(useInputScript) } {
        onTorRegOptSel $setupVals(torRegAction)
        autoSetupLog "Registry page:"
        switch $ctrlVals(torRegAction) {
            torRegStartup {
                autoSetupLog "\t$ctrlVals(torRegStartup)"
            }
            torRegRemote {
                autoSetupLog "\t$ctrlVals(torRegRemote)"
            }
            torRegManual {
                autoSetupLog "\t$ctrlVals(torRegManual)"
            }
            torRegNTServ {
                autoSetupLog "\t$ctrlVals(torRegNTServ)"
            }
            default {
                autoSetupLog "\tTornado registry process: unknown option: \
                $ctrlVals(torRegAction)"
            }
        }

        nextCallback
    } else {

        if {[regOptionRegValueRead] == ""} {
            set setupVals(torRegOption) torRegStartup
        }

        controlCheckSet $w.$setupVals(torRegOption) 1
        controlFocusSet $w.$setupVals(torRegOption)
        onTorRegOptSel $setupVals(torRegOption)

        controlEnable $w.backButt 1
        controlEnable $w.nextButt 1
    }
}

#############################################################################
#
# pageProcess(torRegistry) - process inputs from torRegistry page
#
# This procedure will process input from torRegisry page
#
# SYNOPSIS
# .tS
# pageProcess(torRegistry)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 when successful
#
# ERRORS: N/A
#

proc pageProcess(torRegistry) {} {
    global ctrlVals
    global setupVals
    global infVals

    if {"[windRegValueRead]" == ""} {
        set setupVals(registry) localhost
    }

    beginWaitCursor
    switch $ctrlVals(torRegAction) {

        torRegStartup {
            pageRemove remoteRegistryHost
            set infVals(torRegStartup) 1
        }

        torRegRemote {
            set infVals(torRegRemote) 1
            # user selected to configure a remote registry
        }

        torRegManual {
            # user wants to install the registry
            # manually

            set infVals(torRegManual) 1
            pageRemove remoteRegistryHost
        }

        torRegNTServ {
            pageRemove remoteRegistryHost
            set infVals(torRegNTServ) 1
        }

        default {
            puts "tor registry process: unknown option: \
                $ctrlVals(torRegAction)"
        }
    }

    set infVals(addRegOption) 1

    # added this because we would like to come back to the registry
    # and remember what we selected

    set setupVals(torRegOption) $ctrlVals(torRegAction)

    searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]
    queueExecute
    set infVals(addRegOption) 0
    endWaitCursor
    return 1
}

#############################################################################
#
# onTorRegOptSel - set the variable in ctrlVals when option is changed
#
# This procedure will  set the variable in ctrlVals when option is changed
#
# SYNOPSIS
# .tS
# onTorRegOptSel <opt>
# .tE
#
# PARAMETERS:
# .IP opt
# option selected
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onTorRegOptSel {opt} {
    global ctrlVals

    set ctrlVals(torRegAction) $opt
}

#############################################################################
#
# regOptionRegValueRead - load tornado registry option from the previous
#                         installation if any
#
# This procedure will load tornado registry option from the previous
# installation if any
#
# SYNOPSIS
# .tS
# regOptionRegValueRead
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: last saved tornado registry selection
#
# ERRORS: N/A
#

proc regOptionRegValueRead {} {
    global setupVals
    global ctrlVals

    # Load tornado registry option from the previous installation if any

    if ![info exists setupVals(torRegOption)] {
        set setupVals(torRegOption) ""

        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
                "Software\\$setupVals(WRS)" \
                registryOption} retVal]} {

            set setupVals(torRegOption) $retVal

        } elseif {![catch {sysRegistryValueRead HKEY_LOCAL_MACHINE \
                "SOFTWARE\\$setupVals(WRS)" \
                registryOption} retVal]} {

            set setupVals(torRegOption) $retVal
        }
    }

    return $setupVals(torRegOption)
}

