# LICAGREE.TCL  - Setup procedures for implementing license-agreement 
#                 wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01c,09apr99,wmd  Jason Anderson will take care of manufacturing the CD with
#                  the correct LICENSE.TXT.  Setup will just read it without
#                  having to determine which file to use.
# 01b,06apr99,wmd  Need to determine if source or Tornado CD.
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# onAcceptButt - set up the wizard buttons after accept button is pushed
#
# This procedure will set up the wizard buttons after accept button is pushed
#
# SYNOPSIS
# .tS
# onAcceptButt
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onAcceptButt {} {
    global ctrlVals

    controlEnable $ctrlVals(mainWindow).nextButt 1
    controlEnable $ctrlVals(mainWindow).acceptButt 0
    controlFocusSet $ctrlVals(mainWindow).nextButt
}

#############################################################################
#
# pageCreate(licAgreement) - display the license agreement file
#
# This procedure will display the license agreement file
#
# SYNOPSIS
# .tS
# pageCreate(licAgreement)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(licAgreement) {} {
    global ctrlVals
    global setupVals

    set ctrlVals(volatileFrm) [list \
                [list label -name message1 \
                            -title [strTableGet 4060_LICENSE_TEXT] \
                            -x 99 -y 10 -w 206 -h 35] \
                [list button -name acceptButt \
                            -title "I &Accept" \
                            -callback onAcceptButt \
                            -x 255 -y 45 -w 50 -h 13] \
                [list text -name licenseFile -border -vscroll \
                            -multiline -readonly \
                            -x 100 -y 60 -width 206 -height 111] \
     ]

    set w [dlgFrmCreate "License Agreement"]
    controlFocusSet $w.acceptButt

    # initialize the text box

    controlTextSet $w.licenseFile [fileContentGet [cdFileNameGet LICENSE.TXT]]

    controlEnable $w.nextButt 0

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "License Agreement page: Accepted and skipped"
        onAcceptButt
        nextCallback
    }

}

#############################################################################
#
# pageProcess(licAgreement) - process inputs from licAgreement page if any
#
# This procedure will process inputs from licAgreement page if any
#
# SYNOPSIS
# .tS
# pageProcess(licAgreement)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 when successful
#
# ERRORS: N/A
#

proc pageProcess(licAgreement) {} {
    return 1
}
