# ICONFNSH.TCL  - Setup procedures for implementing icon-finish wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(iconFinish) - display the last finish page if user selects
#                          to install program groups only
#
# This procedure will display the last page if user selects to install program
# groups only and invoke post-installation procedures such as:
# - processing all commands in queue
# - processing INF files
# - creating folders and icons and opening up the folder
# - migrating registry values from T101 to T2 (currently not done)
#
# SYNOPSIS
# .tS
# pageCreate(iconFinish)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(iconFinish) {} {
    global setupVals
    global ctrlVals

    windowShow $ctrlVals(mainWindow) 0
    searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]
    if {![isUnix]} {
        searchAndProcessSection AddIcon [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]
    }
    queueExecute

    # add call to open up program group for windows only

    if {![isUnix]} {
        # display common program group
        set prgGrp [programPathGet 1]
        if {$prgGrp == "" || $ctrlVals(admin) != "1"} {
            # display user program group
            set prgGrp [programPathGet 0]
        }
        if {$prgGrp != ""} {
            set path [file join $prgGrp [defGroupGet]]
            set path [unixToDos $path]
            catch {exec explorer $path} err
        }

        # source REGSAVE.TCL to migrate registry values from Tornado 1.0 to 2.0
        set regSaveTclFile [cdFileNameGet [file join RESOURCE TCL REGSAVE.TCL]]
        if [file exists $regSaveTclFile] {
           source $regSaveTclFile
        }
    }

    messageBox -informationicon [strTableGet 1212_FINISH]
    nextCallback
}


#############################################################################
#
# pageProcess(iconFinish) - process inputs from iconFinish page if any
#
# This procedure will process inputs from iconFinish page if any
#
# SYNOPSIS
# .tS
# pageProcess(iconFinish)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 when successful
#
# ERRORS: N/A
#

proc pageProcess(iconFinish) {} {
    return 1
}
