# DESTDIR.TCL - Setup procedures for implementing destination-directory
#               wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01d,31mar99,bjl  set infVals(addWinFile) for Windows hosts (spr 26136, 26205).
# 01c,24mar99,bjl  turn off inf write to registry after queueExecute.
# 01b,22mar99,bjl  added beginWaitCursor for page processing.
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(destDir) - prompt users for destination directory
#
# This procedure will prompt users for destination directory
#
# SYNOPSIS
# .tS
# pageCreate(destDir)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(destDir) {} {
    global ctrlVals
    global setupVals

    if {[instTypeGet] == "icon"} {
        set msg [strTableGet 1100_REMOTE_DIR]
        set labelText "Remote Directory"
    } else {
        set msg [strTableGet 1100_DEST_DIR]
        set labelText "Destination Directory"
    }

    set ctrlVals(volatileFrm) [list \
                [list label -name dirLabel \
                            -title $msg \
                            -x 100 -y 10 \
                            -w 186 -h 80] \
                [list label -name dirLabelText \
                            -title $labelText \
                            -x 105 -y 136 -w 100 -h 8] \
                [list frame -name dirFrame \
                            -x 100 -y 146 -w 205 -h 24] \
                [list text -name dirText -border \
                           -x 104 -y 151 \
                           -w 140 -h 14] \
                [list button -name browse -title "B&rowse" \
                             -callback {onBrowse dirText} \
                             -x 249 -y 151 -w 50 -h 14] \
    ]

    windBaseReadFromRegistry
    set w [dlgFrmCreate [strTableGet 1440_TITLE_DESTDIR]]

    controlValuesSet $w.dirText [destDirGet]
    controlFocusSet $w.dirText

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "Destination page:"
        autoSetupLog "\tDestination Directory: [destDirGet]"
        nextCallback
    }
}

#############################################################################
#
# pageProcess(destDir) - process inputs from destDir page
#
# This procedure will process inputs from destDir page
#
# SYNOPSIS
# .tS
# pageProcess(destDir)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 0 if destination directory is unacceptable
#          1 if destination directory is acceptable
#
# ERRORS: N/A
#

proc pageProcess(destDir) {} {
    global setupVals
    global ctrlVals
    global infVals
    global overwritePolicy

    set retVal 1
    set changeDir 0
    
    beginWaitCursor

    # convert all Unix style slashes to backslashes for Windows
    if {[isUnix]} {
        destDirSet \
            [string trim [controlValuesGet $ctrlVals(mainWindow).dirText] " "]
    } else {
        destDirSet [unixToDos \
            [string trim [controlValuesGet $ctrlVals(mainWindow).dirText] " "]]
    }

    if {[regexp {[ ]+} [destDirGet]]} {
        if {![dialog ok "Setup" [strTableGet 1135_DEST_DIR_WARN4]]} {
            set retVal 0
        }
    }

    if {[regexp {^[a-zA-Z]:[\\|\/]*$} [destDirGet] junk]} {

        if {![dialog yes_no "Setup" [strTableGet 1111_DEST_DIR_WARN]]} {
            set retVal 0
        }
    }

    if ![isUnix] {
        # make sure directory has drive name and path

        if {![regexp {^[a-zA-Z]:[\\|\/]*.+$} [destDirGet] junk]} {

            if {![dialog ok "Setup" "Please provide a directory path starting\
                                 with a drive name."]} {
                set retVal 0
            }
        }

        # make sure no directory in path starts with a number
        # check the first name in the directory path.

        if {[regexp {^[a-zA-Z]:[\\|\/]*[0-9]+} [destDirGet] junk]} {
            if {![dialog ok "Setup" \
                "Please provide a directory path starting with a letter\
                 character."] } {
                set retVal 0
            }
        # then check the rest of the directory names.

        } elseif {[regsub -all {\\[0-9]+} [destDirGet] {} ignore]} {
            if {![dialog ok "Setup" \
                "Please provide directory names starting with letter\
                 characters."] } {
                set retVal 0
            }
        }
    }

    if {![file isdirectory [destDirGet]] && "$retVal" == "1"} {
        # test automation

        if { !$ctrlVals(useInputScript) } {

            # yes = 0 ; no = 1

            set doNotCreateDirectory \
                [dialog yes_no "Setup" [strTableGet 1110_DEST_DIR_WARN]]
        } else {
            set doNotCreateDirectory 0
        }

        switch $doNotCreateDirectory {
            0 {
                # create directory

                if {![file exists [destDirGet]]} {

                    # workaround for: overWritePolicy dialog box appears
                    # even if user installs to a new directory

                    set overwritePolicy(ALL) 1

                    if {[catch {file mkdir [destDirGet]} error]} {

                        if {![file writable [destDirGet]]} {
                            messageBox [strTableGet 1130_DEST_DIR_WARN3]
                        } else {
                            messageBox [strTableGet 1122_DEST_DIR_WARN2]
                        }
                        set retVal 0
                    }
                    # test automation

                    if { $ctrlVals(useInputScript) } {
                       autoSetupLog "\tCreating new directory: [destDirGet]"
                    }
                } {
                   # test automation

                   if { !$ctrlVals(useInputScript) } {
                        messageBox [strTableGet 1120_DEST_DIR_WARN2]
                   } else {
                        autoSetupLog "[strTableGet 1120_DEST_DIR_WARN2]"
                   }
                   set retVal 0
                }
            }
            1 {
                # do not create directory
                set retVal 0
            }
        }
    } else {

        # test automation

        if { $ctrlVals(useInputScript) } {
            autoSetupLog "\tOverwrite existing directory: [destDirGet]"
        }
    }

    # Initiate the logging process

    if {"$retVal" == "1"} {
        if {[instTypeGet] != ""} {
            uninstStart [instTypeGet]
        } else {
            uninstStart
        }
    }

    set infVals(addDestDir) 1

    # register file types only on Windows hosts since MainWin does
    # not show file extensions with file dialogs.   

    if {![isUnix] && $infVals(addDestDir)} {
        set infVals(addWinFile) 1     
    } else {
        set infVals(addWinFile) 0     
    }

    searchAndProcessSection AddRegistry [cdFileNameGet [file join RESOURCE \
                                         INF TORNADO.INF]]
    queueExecute
    set infVals(addDestDir) 0
    set infVals(addWinFile) 0
    return $retVal
}

#############################################################################
#
# windBaseReadFromRegistry - read WIND_BASE value from registry and set
#                            it as default installation location
#
# This procedure will read WIND_BASE value from registry and set
# it as default installation location
#
# SYNOPSIS
# .tS
# windBaseReadFromRegistry
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc windBaseReadFromRegistry {} {
    global setupVals

    # Initialize wind_base from registry

    if {"[destDirGet]" == ""} {
        if {![catch {sysRegistryValueRead HKEY_CURRENT_USER \
                "Software\\$setupVals(WRS)" "WIND_BASE"} destDir]} {

            destDirSet $destDir

        } elseif {![catch {sysRegistryValueRead HKEY_LOCAL_MACHINE \
                "SOFTWARE\\$setupVals(WRS)" "WIND_BASE"} destDir]} {

            destDirSet $destDir
        } else {
            if {[windHostTypeGet] == "x86-win32"} {
                destDirSet "C:\\Tornado"
            } else {
                destDirSet /usr/wind
            }
        }
    }
}

#############################################################################
#
# onBrowse - set the value in edit box when a directory is selected
#            from the browse window
#
# This procedure will set the value in edit box when a directory is selected
# from the browse window
#
# SYNOPSIS
# .tS
# onBrowse <ctrlName>
# .tE
#
# PARAMETERS:
# .IP ctrlName
# control name which will have the new value
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onBrowse {ctrlName} {
    global ctrlVals

    set retDir [dirBrowseDialogCreate -title "Directory"]

    if {"$retDir" != ""} {
        controlValuesSet $ctrlVals(mainWindow).$ctrlName $retDir
    }
}
