# CHOICE.TCL - Setup procedures for implementing installation-choice wizard page
#
# Copyright 1999 Wind River Systems, Inc
#
# modification history
# --------------------
# 01b,17feb99,tcy  added new variable setupVals(iconInstallation) to denote
#                  program group installation
# 01a,26jan99,tcy  extracted from INSTW32.TCL.
#

#############################################################################
#
# pageCreate(installChoice) - displays choices of installation
#
# This procedure will display choices of installation such as:
# Full Install  - install all or selected number of Tornado products
# Program Group - install the Tornado program group and icons only
#
# SYNOPSIS
# .tS
# pageCreate(installChoice)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc pageCreate(installChoice) {} {
    global ctrlVals
    global setupVals
    global unixFullInstPages
    global winFullInstPages

    set ctrlVals(volatileFrm) [list \
                [list label -name message1 \
                            -title "Choose the type of installation:" \
                            -x 99 -y 10 -w 206 -h 12] \
                [list choice -name fullInstallChoice -newgroup -auto \
                            -title "Full Install" \
                            -x 99 -y 27 -w 50 -h 14 \
                            -callback onFullInstall] \
                [list choice -name prgGrpChoice -auto \
                            -title "Program Group" \
                            -x 99 -y 61 -w 70 -h 14 \
                            -callback onPrgGrpInstall] \
                [list label -name fullLabel \
                            -title [strTableGet 1105_FULL_INSTALL] \
                            -x 111 -y 41 -w 198 -h 22] \
                [list label -name prgGrpLabel\
                            -title [strTableGet 1107_PROGRAM_GROUP] \
                            -x 111 -y 75 -w 198 -h 24] \
    ]

    set w [dlgFrmCreate "Installation Options"]

    controlCheckSet $w.fullInstallChoice 1

    # test automation

    if { $ctrlVals(useInputScript) } {
        autoSetupLog "Installation Options page:"
        if {![isUnix]} {
            set ctrlVals(pageList) \
                [concat $ctrlVals(pageList) $winFullInstPages]
            pageRemove projectInfo
        }
        nextCallback
    }
}

#############################################################################
#
# pageProcess(installChoice) - process inputs from installChoice page if any
#
# This procedure will process inputs from installChoice page if any
#
# SYNOPSIS
# .tS
# pageProcess(installChoice)
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: 1 when successful
#
# ERRORS: N/A
#

proc pageProcess(installChoice) {} {
    return 1
}

#############################################################################
#
# onFullInstall - set up wizard pages when full installation option is selected
#
# This procedure is a callback which sets up wizard pages when full \
# installation is selected
#
# SYNOPSIS
# .tS
# onFullInstall
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onFullInstall {} {
    global ctrlVals
    global winFullInstPages

    instTypeSet ""
    if {![isUnix]} {
        initPageList
        set ctrlVals(pageList) [concat $ctrlVals(pageList) $winFullInstPages]
    }
    if {[string compare [instKeyGet] "none"] == 0} {
        # the install key is "none" remove the project info page

        controlDestroy  $ctrlVals(mainWindow).noKeyText
    }
}

#############################################################################
#
# onPrgGrpInstall - set up wizard pages when program group option is selected
#
# This procedure is a callback which sets up wizard pages when program \
# group is selected
#
# SYNOPSIS
# .tS
# onPrgGrpInstall
# .tE
#
# PARAMETERS: N/A
#
# RETURNS: N/A
#
# ERRORS: N/A
#

proc onPrgGrpInstall {} {
    global ctrlVals
    global winPrgGrpPages
    global tornadoInstalled
    global setupVals

    instTypeSet icon
    set tornadoInstalled 1

    # Denote program group installation; used in proc regTornado()

    set setupVals(iconInstallation) 1

    if {![isUnix]} {
        initPageList
        set ctrlVals(pageList) [concat $ctrlVals(pageList) $winPrgGrpPages]
    }
}
